package com.patzn.lims.equip.entity;

import java.math.BigDecimal;
import java.util.Date;
import com.patzn.lims.core.bean.BaseEntity;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 仪器保养实施历史表
 * </p>
 *
 * @author wwd
 * @since 2020-03-28
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsEquipMaintainHistory extends BaseEntity {

    @ApiModelProperty(value = "仪器保养ID")
	private Long maintainId;
    @ApiModelProperty(value = "创建人ID")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;
    @ApiModelProperty(value = "创建人姓名")
	private String uname;
    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;
    @ApiModelProperty(value = "修改时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;
    @ApiModelProperty(value = "操作")
	private String operation;
    @ApiModelProperty(value = "记录分类0保养1实施")
	private Integer type;
    @ApiModelProperty(value = "仪器id")
	private Long equipId;
    @ApiModelProperty(value = "维保内容")
	private String maintainContent;
    @ApiModelProperty(value = "企业ID")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;
    @ApiModelProperty(value = "操作备注")
	private String remark;
    @ApiModelProperty(value = "计划维修开始时间")
	private Date maintainStartTimePlan;
    @ApiModelProperty(value = "计划维修结束时间")
	private Date maintainEndTimePlan;
    @ApiModelProperty(value = "养护人")
	private String maintainerNames;
    @ApiModelProperty(value = "维护费用")
	private BigDecimal maintainFee;
    @ApiModelProperty(value = "实际维修开始时间")
	private Date maintainStartTimeActual;
    @ApiModelProperty(value = "实际维修结束时间")
	private Date maintainEndTimeActual;
    @ApiModelProperty(value = "实际维修养护人")
	private String maintainerNamesActual;
    @ApiModelProperty(value = "计划名称")
	private String name;
    @ApiModelProperty(value = "编号")
	private String num;
    @ApiModelProperty(value = "详情")
	private String details;
    @ApiModelProperty(value = "修改后保养内容")
	private String lmaintainContent;
    @ApiModelProperty(value = "计划维修开始时间修改前")
	private Date lmaintainStartTimePlan;
    @ApiModelProperty(value = "计划维修结束时间修改后")
	private Date lmaintainEndTimePlan;
    @ApiModelProperty(value = "实际维修开始时间修改前")
	private Date lmaintainStartTimeActual;
    @ApiModelProperty(value = "实际修改结束时间修改后")
	private Date lmaintainEndTimeActual;
    @ApiModelProperty(value = "修改后养护人")
	private String lmaintainerNames;
    @ApiModelProperty(value = "修改后维护费用")
	private BigDecimal lmaintainFee;
    @ApiModelProperty(value = "修改后实际维护养护人")
	private String lmaintainerNamesActual;


}
