package com.patzn.lims.equip.entity;

import java.math.BigDecimal;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.patzn.lims.core.bean.BaseEntity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 
 * </p>
 *
 * @author wwd
 * @since 2020-03-28
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsEquipMaintainManage extends BaseEntity {

    @ApiModelProperty(value = "维保单详情id")
	private Long detailId;
    @ApiModelProperty(value = "状态（0待保养，1保养中，2已保养，3已提交, 4已废止）")
	private Integer status;
    @ApiModelProperty(value = "维保费用")
	private BigDecimal maintainFee;
    @ApiModelProperty(value = "备注")
	private String remark;
    @ApiModelProperty(value = "公司id")
	private Long companyId;
    @ApiModelProperty(value = "实际维修开始时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
	private Date maintainStartTimeAct;
    @ApiModelProperty(value = "实际维修结束时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
	private Date maintainEndTimeAct;
    @ApiModelProperty(value = "实际维护保养人")
	private String maintainerNamesActual;


}
