package com.patzn.lims.equip.entity;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableLogic;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 仪器采购订单表
 * </p>
 *
 * @author wwd
 * @since 2020-03-27
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsEquipPurchase extends BaseEntity {

    @ApiModelProperty(value = "申请名称")
	private String name;
    @ApiModelProperty(value = "状态（0草稿，1待技术主管审批，2待中心主任审批，3设备待验收，4待存档入库，5申购成功，6申购驳回，7中心主任废除，8设备验收驳回，9审批完成-通过，10审批完成-不通过）")
	private Integer status;
    @ApiModelProperty(value = "申请原因")
	private String applyReason;
    @ApiModelProperty(value = "申请人id")
	private Long applyId;
    @ApiModelProperty(value = "申请时间")
	private Date applyTime;
    @ApiModelProperty(value = "技术主管意见")
	private String firstStepAdvice;
    @ApiModelProperty(value = "技术主管id")
	private Long firstStepId;
    @ApiModelProperty(value = "技术主管签字时间")
	private Date firstStepTime;
    @ApiModelProperty(value = "中心主任意见")
	private String secondStepAdvice;
    @ApiModelProperty(value = "中心主任id")
	private Long secondStepId;
    @ApiModelProperty(value = "中心主任签字时间")
	private Date secondStepTime;
    @ApiModelProperty(value = "登记人id")
	private Long registerId;
    @ApiModelProperty(value = "登记时间")
	private Date registerTime;
    @ApiModelProperty(value = "备注")
	private String remark;
	@TableField(fill = FieldFill.INSERT)
    @ApiModelProperty(value = "公司id")
	private Long companyId;
    @ApiModelProperty(value = "验收报告")
	private String files;
	private String applyName;
	private String firstStepName;
	private String secondStepName;
	private String registerName;
	private Long userId;
	private Integer tempStatus;
    @ApiModelProperty(value = "0正常1删除")
    @TableLogic
	private Integer deleted;
    @ApiModelProperty(value = "委托单编号")
	private String num;


}
