package com.patzn.lims.equip.entity;

import java.math.BigDecimal;
import com.patzn.lims.core.bean.BaseEntity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 仪器采购详情信息表
 * </p>
 *
 * @author wwd
 * @since 2020-03-27
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsEquipPurchaseDetail extends BaseEntity {

    @ApiModelProperty(value = "采购id")
	private Long purchaseId;
    @ApiModelProperty(value = "仪器id")
	private Long productId;
	private Long supplierId;
	private Long classId;
	private String classIds;
	private String name;
	private String spec;
	private String brand;
	private BigDecimal price;
	private String productPlace;
	private String meterType;
	private String uncertainty;
	private String accuracy;
	private String range;
	private String techParams;
	private String productRemark;
	private Integer counts;
	private String uses;
	private String remark;
	private Long companyId;
    @ApiModelProperty(value = "技术参数纯文本")
	private String techParamsText;
    @ApiModelProperty(value = "状态（0草稿，1待审批,2待入库，3 待）")
	private Integer status;
    @ApiModelProperty(value = "入库数量")
	private Long inSock;
    @ApiModelProperty(value = "供应商名称")
	private String supplierName;
    @ApiModelProperty(value = "相关标准")
	private String relatedStandards;


}
