package com.patzn.lims.equip.entity;

import java.math.BigDecimal;
import java.util.Date;
import com.patzn.lims.core.bean.BaseEntity;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 试验耗材采购关联表
 * </p>
 *
 * @author wwd
 * @since 2020-03-27
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsEquipRelDelivery extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "企业 ID")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

	@ApiModelProperty(value = "创建人 ID")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;

	@ApiModelProperty(value = "出库 ID")
	private Long orderId;

	@ApiModelProperty(value = "规格")
	private String spec;

	@ApiModelProperty(value = "价格")
	private BigDecimal price;

	@ApiModelProperty(value = "备注")
	private String remark;

	@ApiModelProperty(value = "审批状态 0、正常 1、驳回 2、调整")
	private Integer state;

	@ApiModelProperty(value = "状态 0、待入库 1、入库")
	private Integer status;

	@ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;

	@ApiModelProperty(value = "设备 ID")
	private Long equipId;

	@ApiModelProperty(value = "设备名称")
	private String equipName;

	@ApiModelProperty(value = "设备编号")
	private String equipNum;

	@ApiModelProperty(value = "开始时间")
	//@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm")
	@TableField(fill = FieldFill.INSERT)
	private Date useStartTime;

	@ApiModelProperty(value = "结束时间")
	//@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm")
	@TableField(fill = FieldFill.INSERT)
	private Date useEndTime;

	@ApiModelProperty(value = "制造商")
	private String manufacturer;

	@ApiModelProperty(value = "用途")
	private String uses;

	@ApiModelProperty(value = "开始性能")
	private String performanceStart;

	@ApiModelProperty(value = "结束性能")
	private String performanceEnd;

	@ApiModelProperty(value = "使用人")
	private String applyName;

	@ApiModelProperty(value = "发放人")
	private String grantName;

	@ApiModelProperty(value = "申请人Id")
	private Long applyId;

	@ApiModelProperty(value = "存储位置")
	private String  locationName;



}
