package com.patzn.lims.equip.entity;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableLogic;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 仪器维修信息表
 * </p>
 *
 * @author wwd
 * @since 2020-03-30
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsEquipRepair extends BaseEntity {

    @ApiModelProperty(value = "申请名称")
	private String name;
    @ApiModelProperty(value = "登记状态(0草稿，1待技术主管审批，2技术主管审批通过，3技术主管审批驳回，4审批完成-通过，5审批完成-不通过)")
	private Integer status;
    @ApiModelProperty(value = "责任人id")
	private Long applyId;
    @ApiModelProperty(value = "申请时间")
	private Date applyTime;
    @ApiModelProperty(value = "技术主管意见")
	private String firstStepAdvice;
    @ApiModelProperty(value = "技术主管")
	private Long firstStepId;
    @ApiModelProperty(value = "主管签字时间")
	private Date firstStepTime;
    @ApiModelProperty(value = "登记人")
	private Long registerId;
    @ApiModelProperty(value = "登记时间")
	private Date registerTime;
    @ApiModelProperty(value = "备注")
	private String remark;
    @ApiModelProperty(value = "公司id")
    @TableField(fill = FieldFill.INSERT)
	private Long companyId;
    @ApiModelProperty(value = "申请原因")
	private String applyReason;
    @ApiModelProperty(value = "申请人姓名")
	private String applyName;
    @ApiModelProperty(value = "技术主管姓名")
	private String firstStepName;
    @ApiModelProperty(value = "登记人姓名")
	private String registerName;
    @ApiModelProperty(value = "当前用户id")
	private Long userId;
    @ApiModelProperty(value = "临时状态（0临时数据，1正式数据）")
	private Integer tempStatus;
    @ApiModelProperty(value = "维修单编号")
	private String num;
    @ApiModelProperty(value = "删除0否1是")
    @TableLogic
	private Integer deleted;


}
