package com.patzn.lims.equip.entity;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableLogic;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 仪器维修详情信息表
 * </p>
 *
 * @author wwd
 * @since 2020-03-30
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsEquipRepairDetail extends BaseEntity {

    @ApiModelProperty(value = "维修id")
	private Long repairId;
    @ApiModelProperty(value = "设备id")
	private Long equipId;
    @ApiModelProperty(value = "故障分析")
	private String breakdown;
    @ApiModelProperty(value = "备注")
	private String remark;
    @ApiModelProperty(value = "公司id")
    @TableField(fill = FieldFill.INSERT)
	private Long companyId;
    @ApiModelProperty(value = "计划维修开始时间")
	private Date repairStartTimePlan;
    @ApiModelProperty(value = "计划维修结束时间")
	private Date repairEndTimePlan;
    @ApiModelProperty(value = "维修人员id")
	private String repairerIds;
    @ApiModelProperty(value = "维修人员姓名")
	private String repairerNames;
    @ApiModelProperty(value = "删除0否1是")
    @TableLogic
	private Integer deleted;
    @ApiModelProperty(value = "故障时间")
	private Date failureTime;


}
