package com.patzn.lims.equip.entity;

import java.math.BigDecimal;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.patzn.lims.core.bean.BaseEntity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 
 * </p>
 *
 * @author wwd
 * @since 2020-03-30
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsEquipRepairManage extends BaseEntity {

    @ApiModelProperty(value = "维修单详情id")
	private Long detailId;
    @ApiModelProperty(value = "状态（0待维修，1维修中，2已维修，3已提交，4已废止）")
	private Integer status;
    @ApiModelProperty(value = "维修方式")
	private String repairMethod;
    @ApiModelProperty(value = "维修费用")
	private BigDecimal repairFee;
    @ApiModelProperty(value = "备注")
	private String remark;
    @ApiModelProperty(value = "公司id")
    @TableField(fill = FieldFill.INSERT)
	private Long companyId;
    @ApiModelProperty(value = "实际维修开始时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
	private Date repairStartTimeAct;
    @ApiModelProperty(value = "实际维修结束时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
	private Date repairEndTimeAct;
    @ApiModelProperty(value = "实际维修人")
	private String repairerNamesAct;


}
