package com.patzn.lims.equip.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 维修核查表
 * </p>
 *
 * @author SunYunGang
 * @since 2019-01-09
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsEquipRepairManageHistory extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "维修单id")
	private Long repairId;

    @ApiModelProperty(value = "创建人id")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;

    @ApiModelProperty(value = "创建人姓名")
	private String uname;

    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;

    @ApiModelProperty(value = "操作")
	private String operation;

    @ApiModelProperty(value = "备注")
	private String remark;

    @ApiModelProperty(value = "详情")
	private String details;

    @ApiModelProperty(value = "实际维修开始时间")
	private Date repairStartTimeAct;

    @ApiModelProperty(value = "实际维修结束时间")
	private Date repairEndTimeAct;

    @ApiModelProperty(value = "维修方式")
	private String repairMethod;

    @ApiModelProperty(value = "实际维修费用")
	private BigDecimal repairFee;

    @ApiModelProperty(value = "维修单号")
	private String num;

    @ApiModelProperty(value = "维修原因")
	private String repairRemark;

	@ApiModelProperty(value = "实际维修开始时间修改后")
	private Date lrepairStartTimeAct;

	@ApiModelProperty(value = "实际维修结束时间修改后")
	private Date lrepairEndTimeAct;

	@ApiModelProperty(value = "修改方式修改后")
	private String lrepairMethod;

	@ApiModelProperty(value = "实际维修费用修改后")
	private BigDecimal lrepairFee;

	@ApiModelProperty(value = "企业ID")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;
}
