package com.patzn.lims.equip.entity;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.patzn.lims.core.bean.BaseEntity;
import com.patzn.lims.equip.enums.EquipScrapApplyEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 仪器报废信息表
 * </p>
 *
 * @author patzn
 * @since 2017-11-30
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsEquipScrap extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "申请名称")
	private String name;

    @ApiModelProperty(value = "状态")
	private Integer status;

    @ApiModelProperty(value = "申请原因")
	private String applyReason;

    @ApiModelProperty(value = "申请人id")
	private Long applyId;

    @ApiModelProperty(value = "申请人名")
    private String applyName;

    @ApiModelProperty(value = "申请时间")
	private Date applyTime;

    @ApiModelProperty(value = "技术主管意见")
	private String firstStepAdvice;

    @ApiModelProperty(value = "技术主管id")
	private Long firstStepId;

    @ApiModelProperty(value = "技术主管人名")
    private String firstStepName;

    @ApiModelProperty(value = "技术主管签字时间")
	private Date firstStepTime;

    @ApiModelProperty(value = "中心主任意见")
	private String secondStepAdvice;

    @ApiModelProperty(value = "中心主任id")
	private Long secondStepId;

    @ApiModelProperty(value = "中心主任人名")
    private String secondStepName;

    @ApiModelProperty(value = "中心主任签字时间")
	private Date secondStepTime;

    @ApiModelProperty(value = "登记人id")
	private Long registerId;

    @ApiModelProperty(value = "登记人名")
    private String registerName;

    @ApiModelProperty(value = "登记时间")
	private Date registerTime;

    @ApiModelProperty(value = "备注")
	private String remark;

    @ApiModelProperty(value = "公司id")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

    @ApiModelProperty(value = "当前用户id")
    private Long userId;

    @ApiModelProperty(value = "临时状态")
    private Integer tempStatus;

    @ApiModelProperty(value = "编号")
    private String num;

    @ApiModelProperty(value = "0、正常 1、删除")
    @TableLogic
    private Integer deleted;

}
