package com.patzn.lims.equip.entity;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 仪器报废详情信息表
 * </p>
 *
 * @author patzn
 * @since 2017-11-30
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsEquipScrapDetail extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "报废id")
	private Long scrapId;

    @ApiModelProperty(value = "仪器id")
	private Long equipId;

	@ApiModelProperty(value = "金额")
	private BigDecimal money;

    @ApiModelProperty(value = "备注")
	private String remark;

    @ApiModelProperty(value = "公司id")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

	@ApiModelProperty(value = "报废原因")
	private String reason;

	@ApiModelProperty(value = "创建人id")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;

	@ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;

	@ApiModelProperty(value = "最后人id")
	@TableField(fill = FieldFill.UPDATE)
	private Long lid;

	@ApiModelProperty(value = "最后修改时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;

	@ApiModelProperty(value = "是否删除0否1是")
	@TableLogic
	private Integer deleted;


}
