package com.patzn.lims.equip.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 仪器报废管理
 * </p>
 *
 * @author patzn123
 * @since 2018-01-17
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsEquipScrapManage extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "报废详情id")
	private Long detailId;

	@ApiModelProperty(value = "状态（0待报废，1已报废，2已提交，3已废止）")
	private Integer status;
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    @ApiModelProperty(value = "报废日期")
	private Date scrapDate;

    @ApiModelProperty(value = "备注")
	private String remark;

    @ApiModelProperty(value = "公司id")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

    @ApiModelProperty(value = "实际报废费用")
	private BigDecimal scrapFee;

    @ApiModelProperty(value = "实际报废负责人")
	private String scrapNameAct;

    @ApiModelProperty(value = "报废处理方式")
	private String scrapMode;


}
