package com.patzn.lims.equip.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 仪器报废历史记录表
 * </p>
 *
 * @author SunYunGang
 * @since 2019-01-09
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsEquipScrapManageHistory extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "用户Id")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;

    @ApiModelProperty(value = "企业Id")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

    @ApiModelProperty(value = "报废单Id")
	private Long scrapId;

    @ApiModelProperty(value = "创建人")
	private String uname;

    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;

    @ApiModelProperty(value = "删除0否1是")
    @TableLogic
	private Integer deleted;

    @ApiModelProperty(value = "操作")
	private String operation;

    @ApiModelProperty(value = "报废单编号")
	private String num;

    @ApiModelProperty(value = "详情")
	private String details;

    @ApiModelProperty(value = "申请原因")
	private String applyReason;

    @ApiModelProperty(value = "备注")
	private String remark;

    @ApiModelProperty(value = "报废时间")
	private Date scrapDate;

    @ApiModelProperty(value = "实际报废费用")
	private BigDecimal scrapFee;

    @ApiModelProperty(value = "实际报废负责人")
	private String scrapNameAct;

    @ApiModelProperty(value = "报废处理方式")
	private String scrapMode;


	@ApiModelProperty(value = "报废时间修改后")
	private Date lscrapDate;

	@ApiModelProperty(value = "实际报废费用修改后")
	private BigDecimal lscrapFee;

	@ApiModelProperty(value = "实际报废负责人修改后")
	private String lscrapNameAct;

	@ApiModelProperty(value = "报废处理方式修改后")
	private String lscrapMode;


}
