package com.patzn.lims.equip.entity;

import java.util.Date;
import com.patzn.lims.core.bean.BaseEntity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 仪器使用记录信息表
 * </p>
 *
 * @author wwd
 * @since 2020-03-28
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsEquipUseRecord extends BaseEntity {

    @ApiModelProperty(value = "仪器id")
	private Long equipId;
    @ApiModelProperty(value = "状态(0草稿，1已提交)")
	private Integer status;
    @ApiModelProperty(value = "使用日期")
	private Date useDate;
    @ApiModelProperty(value = "使用开始时间")
	private Date useStartTime;
    @ApiModelProperty(value = "使用结束时间")
	private Date useEndTime;
    @ApiModelProperty(value = "开始性能")
	private String performanceStart;
    @ApiModelProperty(value = "结束性能")
	private String performanceEnd;
    @ApiModelProperty(value = "使用人id")
	private Long userId;
    @ApiModelProperty(value = "检品编号/批号")
	private String checkNum;
    @ApiModelProperty(value = "检测项目")
	private String checkItem;
    @ApiModelProperty(value = "其他要求")
	private String other;
    @ApiModelProperty(value = "登记时间")
	private Date registerTime;
    @ApiModelProperty(value = "备注")
	private String remark;
    @ApiModelProperty(value = "公司id")
	private Long companyId;
    @ApiModelProperty(value = "登记人id")
	private Long registerId;
    @ApiModelProperty(value = "使用人姓名")
	private String userName;
    @ApiModelProperty(value = "发放人")
	private String registerName;
    @ApiModelProperty(value = "关联预约id，非必填")
	private Long orderId;
    @ApiModelProperty(value = "使用实验室id")
	private Long labId;
    @ApiModelProperty(value = "使用实验室名称")
	private String labName;
    @ApiModelProperty(value = "使用原因")
	private String reason;
    @ApiModelProperty(value = "归还人")
	private String returnName;
    @ApiModelProperty(value = "归还时间")
	private Date returnDate;
    @ApiModelProperty(value = "接收人")
	private String receiveName;
    @ApiModelProperty(value = "是否归还")
	private Integer isReturn;
    @ApiModelProperty(value = "仪器编号")
	private String equipNum;
    @ApiModelProperty(value = "仪器使用申请人")
	private String useApplyer;
    @ApiModelProperty(value = "仪器产地")
	private String productPlace;
    @ApiModelProperty(value = "0:手动 1:出入库")
	private Integer type;
    @ApiModelProperty(value = "相关零件情况")
	private String parts;


}
