package com.patzn.lims.equip.enums;

/**
 * 仪器文件类型枚举类
 */
public enum EquipFileTypeEnum {
    PRODUCT(0, "产品说明"),
    PURCHASE(1, "采购类型"),
    INFO(3, "资产说明"),
    MAINTAIN(4, "保养"),
    CHECK(5, "期间核查"),
    //二维码图片信息
    QRCODE(7,"设备二维码"),
    VERIFY(6, "检定");


    private int value;
    private String display;

    EquipFileTypeEnum(int value, String display) {
        this.value = value;
        this.display = display;
    }

    public int getValue() {
        return value;
    }

    public String getName() {
        return name();
    }

    public String getDisplay() {
        return display;
    }
}