package com.patzn.lims.equip.enums;

/**
 * 仪器状态枚举类
 */
public enum EquipLogStatusEnum {
    /**
     * 使用
     */
    USE(1, "使用"),
    /**
     * 保养
     */
    MAINTAIN(2, "保养"),
    /**
     * 维修
     */
    REPAIR(3, "维修"),
    /**
     * 预约使用
     */
    ORDER_USE(4, "预约使用"),

    /**
     * 预约保养
     */
    ORDER_MAINTAIN(5, "预约保养"),

    /**
     * 预约维修
     */
    ORDER_REPAIR(6, "预约维修"),;

    private int value;
    private String display;

    EquipLogStatusEnum(int value, String display) {
        this.value = value;
        this.display = display;
    }


    public static EquipLogStatusEnum valueOf(int value) {
        EquipLogStatusEnum[] cse = EquipLogStatusEnum.values();
        for (EquipLogStatusEnum cs : cse) {
            if (cs.value == value) {
                return cs;
            }
        }
        return null;
    }

    public int getValue() {
        return value;
    }

    public String getName() {
        return name();
    }

    public String getDisplay() {
        return display;
    }
}