package com.patzn.lims.equip.enums;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.patzn.lims.core.enums.JsonEnumDeserializer;

import java.io.Serializable;

@JsonDeserialize(using = JsonEnumDeserializer.class)
public enum EquipScrapApplyEnum  {
    DRAFT(0, "草稿"),

    TECHNOLOGY_CHECK(1, "技术主管审批中"),

    DIRECTOR_CENTER_CHECK(2, "技术主管审批同意"),

    TECHNOLOGY_CHECK_BACK(3, "技术主管审批驳回"),

    DIRECTOR_CENTER_PASS(4, "主任审批通过"),

    DIRECTOR_CENTER_BACK(5, "主任审批驳回"),

    END(6, "审批完成"),

    STOP(7, "审批终止"),
    ;


    private int value;
    private String display;

    EquipScrapApplyEnum(int value, String display) {
        this.value = value;
        this.display = display;
    }

    public static EquipScrapApplyEnum valueOf(int value) {
        EquipScrapApplyEnum[] cse = EquipScrapApplyEnum.values();
        for (EquipScrapApplyEnum cs : cse) {
            if (cs.value == value) {
                return cs;
            }
        }
        return null;
    }

    public Serializable getValue() {
        return this.value;
    }

    public String getName() {
        return this.name();
    }

    public String getDisplay() {
        return this.display;
    }
}
