package com.patzn.lims.equip.enums;

/**
 * 仪器状态枚举类
 */
public enum EquipStatusEnum {
    /**
     * 闲置
     */
    ASIDE(0, "闲置"),
    /**
     * 使用
     */
    USE(1, "使用"),
    /**
     * 保养
     */
    MAINTAIN(2, "保养"),
    /**
     * 维修
     */
    REPAIR(3, "维修"),
    /**
     * 报废
     */
    SCRAP(4, "报废");

    private int value;
    private String display;

    EquipStatusEnum(int value, String display) {
        this.value = value;
        this.display = display;
    }

    public int getValue() {
        return value;
    }

    public String getName() {
        return name();
    }

    public String getDisplay() {
        return display;
    }
}