package com.patzn.lims.equip.mapper;

import com.baomidou.mybatisplus.annotation.SqlParser;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.common.Tree;
import com.patzn.lims.core.web.Account;
import com.patzn.lims.equip.entity.LmsEquipClass;
import com.patzn.lims.equip.vo.LmsEquipClassVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 仪器分类信息表 Mapper 接口
 * </p>
 *
 * @author patzn
 * @since 2017-11-30
 */
public interface LmsEquipClassMapper extends BaseMapper<LmsEquipClass> {

    List<LmsEquipClassVO> selectPageRecursive(Page<LmsEquipClassVO> page, @Param("ew") LmsEquipClassVO lmsEquipClass);

    List<LmsEquipClassVO> selectPageRecursive(@Param("ew") LmsEquipClassVO lmsEquipClass);

    List<LmsEquipClassVO> selectEquipClass(Page page, @Param("ew") LmsEquipClassVO lmsEquipClass);

    LmsEquipClassVO selectVOById(@Param("id") Long id);

    @SqlParser(filter = true)
    List<LmsEquipClass> selectClassTree(@Param("equip") LmsEquipClass equipClass, @Param("account") Account account);

    List<LmsEquipClass> selectIncludeRoleId(@Param("roleId") Long roleId);

    List<LmsEquipClass> selectByUserId(@Param("userId") Long userId);

    List<LmsEquipClass> selectClassList(@Param("name") String name, @Param("account") Account account);

    List<LmsEquipClass> selectClassAllTree(@Param("name") String name);

    List<Tree> selectTree(@Param("ew") LmsEquipClass lmsEquipClass, @Param("noCheck")boolean b);
}
