package com.patzn.lims.equip.mapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.common.Tree;
import com.patzn.lims.equip.entity.LmsEquipLocation;
import com.patzn.lims.equip.vo.LmsEquipLocationVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 仪器位置信息表 Mapper 接口
 * </p>
 *
 * @author patzn
 * @since 2017-12-16
 */
public interface LmsEquipLocationMapper extends BaseMapper<LmsEquipLocation> {

    List<Tree> selectTree(@Param("ew") LmsEquipLocation lmsEquipLocation, @Param("noCheck") boolean noCheck);

    List<LmsEquipLocationVO> selectPageVO(Page page, @Param("ew") LmsEquipLocationVO lmsEquipLocationVO);

    List<LmsEquipLocationVO> selectPageVO(@Param("ew") LmsEquipLocationVO lmsEquipLocationVO);

    LmsEquipLocationVO selectVOById(@Param("id") Long id);

    /**
     * 查询树以及树下所有数据
     */
    List<LmsEquipLocationVO> selectPageRecursive(Page page, @Param("ew") LmsEquipLocationVO lmsEquipLocationVO);
}
