package com.patzn.lims.equip.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.IBaseService;
import com.patzn.lims.equip.dto.LmsEquipCheckDTO;
import com.patzn.lims.equip.entity.LmsEquipCheck;
import com.patzn.lims.equip.entity.LmsEquipCheckDetail;
import com.patzn.lims.equip.entity.LmsEquipFile;
import com.patzn.lims.equip.vo.LmsEquipCheckManageVO;
import com.patzn.lims.equip.vo.LmsEquipCheckVO;
import org.springframework.web.multipart.MultipartFile;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * <p>
 *  服务类
 * </p>
 *
 * @author patzn
 * @since 2017-11-30
 */
public interface ILmsEquipCheckService extends IBaseService<LmsEquipCheck> {

    Page<LmsEquipCheckManageVO> page(Page<LmsEquipCheckManageVO> page, LmsEquipCheckManageVO lmsEquipCheckManageVO);

    List<LmsEquipCheck> list(LmsEquipCheck lmsEquipCheck);

    LmsEquipCheckVO getVOById(Long id);

    LmsEquipCheckVO getTemp();

    boolean saveBatchEquipId(Long ids[], LmsEquipCheckDetail lmsEquipCheckDetail, int i);

    boolean edit(LmsEquipCheckDTO lmsEquipCheck);

    boolean add(LmsEquipCheck lmsEquipCheck, int t);

    boolean importLmsEquipCheck(MultipartFile file, Long checkId);

    boolean submit(Long id);

    LmsEquipCheckDetail copyInput(Long id);

    boolean approve(String taskId, String status, String reason);

    List<LmsEquipCheckDetail>vagueInput(String name, String value);

    LmsEquipFile uploadFile(MultipartFile file, LmsEquipCheck lmsEquipCheck, int type);

    void downloadFile(Long id, HttpServletResponse response);

    boolean deleteFiles(Long id, Long checkId, int type);

    LmsEquipCheck selectOne(LmsEquipCheck lmsEquipCheck);

    boolean removeByIds(Long[] ids);

    boolean batchImplementation(LmsEquipCheckDTO lmsEquipCheckDTO);

    void sendMsg();

    LmsEquipFile uploadFileRow(MultipartFile file, LmsEquipCheck lmsEquipCheck);

    Boolean deleteFileBatch(Long[] ids);

    void downloadFiles(Long[] ids, HttpServletResponse response);

    void downloadRow(Long id, HttpServletResponse response);
}
