package com.patzn.lims.equip.service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.common.Tree;
import com.patzn.lims.core.web.Account;
import com.patzn.lims.core.web.IBaseService;
import com.patzn.lims.equip.entity.LmsEquipClass;
import com.patzn.lims.equip.vo.LmsEquipClassVO;
import org.springframework.web.multipart.MultipartFile;
import java.util.Collection;
import java.util.List;
import java.util.Set;

/**
 * <p>
 * 仪器分类信息表 服务类
 * </p>
 *
 * @author patzn
 * @since 2017-11-30
 */
public interface ILmsEquipClassService extends IBaseService<LmsEquipClass> {

    Page<LmsEquipClassVO> page(Page<LmsEquipClassVO> page, LmsEquipClassVO lmsEquipClass);

    List<LmsEquipClassVO> listRecursive(LmsEquipClassVO lmsEquipClass);


    Page<LmsEquipClassVO> pageRecursive(Page<LmsEquipClassVO> page, LmsEquipClassVO lmsEquipClass);

    List<LmsEquipClass> list(LmsEquipClass lmsEquipClassVO);

    LmsEquipClassVO getVOById(Long id);

    boolean existByIds(Long[] ids);

    Boolean removeByIds(Long[] ids);

    List<LmsEquipClass> getClassAllTree(String name);


    List<LmsEquipClass> listByNames(Collection<?> names);


    List<LmsEquipClass> getClassTree(LmsEquipClass equipClass, Account account);

    List<LmsEquipClass> listIncludeRoleId(Long roleId);

    List<LmsEquipClass> listByUserId(Long userId);


    boolean saveClass(LmsEquipClass lmsEquipClass);


    boolean  updateClassById(LmsEquipClass lmsEquipClass);


    Set<String> getAllClassName();

    boolean importEquipClass(MultipartFile file);

    List<Tree> getTree(LmsEquipClass lmsEquipClass);
}
