package com.patzn.lims.equip.service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.common.Tree;
import com.patzn.lims.core.web.IBaseService;
import com.patzn.lims.equip.entity.LmsEquipLocation;
import com.patzn.lims.equip.vo.LmsEquipLocationVO;
import org.springframework.web.multipart.MultipartFile;

import java.util.Collection;
import java.util.List;
import java.util.Set;

/**
 * <p>
 * 仪器位置信息表 服务类
 * </p>
 *
 * @author patzn
 * @since 2017-12-16
 */
public interface ILmsEquipLocationService extends IBaseService<LmsEquipLocation> {

    Page<LmsEquipLocationVO> pageVO(Page<LmsEquipLocationVO> page, LmsEquipLocationVO lmsEquipLocationVO);

    List<LmsEquipLocationVO> listVO(LmsEquipLocationVO lmsEquipLocationVO);

    List<Tree> getTree(LmsEquipLocation lmsEquipLocation);

    LmsEquipLocationVO getVOById(Long id);

    boolean uploadFile(MultipartFile file, LmsEquipLocation lmsEquipLocation);

    boolean deleteFile(Long id);

    List<LmsEquipLocation> listByNames(Collection<?> names);


    Set<String> getAllPosition();

    /**
     * 添加设备位置递归
     */
    Page<LmsEquipLocationVO> pageRecursive(Page<LmsEquipLocationVO> page, LmsEquipLocationVO lmsEquipLocationVO);


}
