package com.patzn.lims.equip.service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.IBaseService;
import com.patzn.lims.equip.entity.LmsEquipFile;
import com.patzn.lims.equip.entity.LmsEquipScrap;
import com.patzn.lims.equip.vo.LmsEquipScrapVO;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * <p>
 * 仪器报废信息表 服务类
 * </p>
 *
 * @author patzn
 * @since 2017-11-30
 */
public interface ILmsEquipScrapService extends IBaseService<LmsEquipScrap> {

    Page<LmsEquipScrapVO> pageVO(Page<LmsEquipScrapVO> page, LmsEquipScrapVO vo);

    Page<LmsEquipScrapVO> pageManage(Page<LmsEquipScrapVO> page, LmsEquipScrapVO vo);

    List<LmsEquipScrap> list(LmsEquipScrap lmsEquipScrap);

    LmsEquipScrapVO getTemp();

    LmsEquipScrapVO getTemp(Long[] ids);

    boolean submit(Long id);

    boolean edit(LmsEquipScrap lmsEquipScrap);

    boolean approve(String taskId, String status, String reason);

    LmsEquipScrap selectOne(LmsEquipScrap queryBean);

    boolean removeIds(Long[] ids);

    LmsEquipFile uploadFile(MultipartFile file, LmsEquipScrap lmsEquipScrap);

    void downloadFile(Long id, HttpServletResponse response);

    boolean deleteFiles(Long id, Long repairId);

    boolean addOne(LmsEquipScrap lmsEquipScrap);

   boolean inputNum(Long id, String num);
}
