package com.patzn.lims.equip.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.core.web.LoginHelper;
import com.patzn.lims.equip.entity.*;
import com.patzn.lims.equip.enums.EquipFileTypeEnum;
import com.patzn.lims.equip.mapper.LmsEquipCheckDetailMapper;
import com.patzn.lims.equip.service.*;
import com.patzn.lims.res.service.ILmsPropertyService;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 期间核查详情信息表 服务实现类
 * </p>
 *
 * @author SunYunGang
 * @since 2019-01-05
 */
@Service
public class LmsEquipCheckDetailServiceImpl extends BaseServiceImpl<LmsEquipCheckDetailMapper, LmsEquipCheckDetail> implements ILmsEquipCheckDetailService {
    @Autowired
    private ILmsEquipCheckService lmsEquipCheckService;
    @Autowired
    private ILmsEquipCheckHostoryService lmsEquipCheckHostoryService;

    @Autowired
    private ILmsPropertyService lmsPropertyService;
    @Autowired
    private ILmsEquipInfoService lmsEquipInfoService;
    @Autowired
    private ILmsEquipFileService lmsEquipFileService;




    @Override
    public Page<LmsEquipCheckDetail> page(Page<LmsEquipCheckDetail> page, LmsEquipCheckDetail lmsEquipCheckDetail) {
        QueryWrapper wrapper = Wrappers.<LmsEquipCheckDetail>query(lmsEquipCheckDetail);
        if(StringUtils.isNotEmpty(lmsEquipCheckDetail.getCheckContent())){
            wrapper.like("check_content",lmsEquipCheckDetail.getCheckContent());
            lmsEquipCheckDetail.setCheckContent(null);
        }
        return this.page(page, wrapper);
    }


    @Override
    public List<LmsEquipCheckDetail> list(LmsEquipCheckDetail lmsEquipCheckDetail) {
        return this.list(Wrappers.<LmsEquipCheckDetail>query(lmsEquipCheckDetail));
    }
    @Override
    public
    boolean removes(Long []ids ){
        PtAssert.fail(ArrayUtils.isEmpty(ids),"请先选择要删除的数据");
        List<LmsEquipCheckDetail>list=super.list(Wrappers.<LmsEquipCheckDetail>query().in("id",ids));

        if(list.size()==0){
            return true;
        }
        LmsEquipCheck lmsEquipCheck = lmsEquipCheckService.getById(list.get(0).getCheckId());
        PtAssert.fail(null==lmsEquipCheck,"该核查单已被删除");
        Object []equip= list.stream().map(e->e.getEquipId()).toArray();
        List<LmsEquipInfo>list1 =lmsEquipInfoService.list(Wrappers.<LmsEquipInfo>query().in("id",equip));
        String names=list1.stream().map(e->e.getName()).collect(Collectors.joining(","));
        LmsEquipCheckHostory lmsEquipCheckHostory = new LmsEquipCheckHostory();
        lmsEquipCheckHostory.setOperation("删除");
        lmsEquipCheckHostory.setUname(LoginHelper.getAccount().getUserName());
        lmsEquipCheckHostory.setType(0);
        lmsEquipCheckHostory.setDetails("删除:"+names);
        lmsEquipCheckHostory.setCheckId(lmsEquipCheck.getId());
        lmsEquipCheckHostory.setName(lmsEquipCheck.getName());
        lmsEquipCheckHostory.setNum(lmsEquipCheck.getNum());
        lmsEquipCheckHostoryService.save(lmsEquipCheckHostory);
        return  super.remove(Wrappers.<LmsEquipCheckDetail>query().in("id",ids));

    }

    @Override
    public List<LmsEquipCheckDetail> getDetailByCheckId(Long checkId) {
        return list(Wrappers.<LmsEquipCheckDetail>query().eq("check_id",checkId));
    }



    @Override
    public   boolean updateByIds(LmsEquipCheckDetail lmsEquipCheckDetail){
        return super.updateById(lmsEquipCheckDetail);

    }


    @Override
    public LmsEquipFile uploadFile(MultipartFile file, LmsEquipCheckDetail lmsEquipCheckDetail, int type) {
        PtAssert.fail(null == lmsEquipCheckDetail.getId(), "请选择一条记录");
        Long companyId = LoginHelper.getAccount().getCompanyId();
        LmsEquipCheckDetail detail = super.getById(lmsEquipCheckDetail.getId());
        LmsEquipCheckHostory lmsEquipCheckHostory = new LmsEquipCheckHostory();
        lmsEquipCheckHostory.setCheckId(lmsEquipCheckDetail.getCheckId());
        //期间核查
        LmsEquipCheck check = lmsEquipCheckService.getById(lmsEquipCheckDetail.getCheckId());
        lmsEquipCheckHostory.setDetails("文件名:" + file.getOriginalFilename());
        lmsEquipCheckHostory.setName(null == check.getName() ? "创建前上传" : check.getName());
        lmsEquipCheckHostory.setOrgName(null == check.getOrgName() ? "创建前上传" : check.getName());
        lmsEquipCheckHostory.setUname(LoginHelper.getAccount().getUserName());
        lmsEquipCheckHostory.setNum(null == check.getNum() ? "创建前上传" : check.getNum());
        lmsEquipCheckHostory.setOperation("上传");
        lmsEquipCheckHostory.setType(type);
        lmsEquipCheckHostoryService.save(lmsEquipCheckHostory);
        //区分公司
        return lmsEquipFileService.addAndUpload(file, "lims", "equip/flow/check/" + companyId + "/", lmsEquipCheckDetail.getId(), EquipFileTypeEnum.CHECK.getValue());
    }

    @Override
    public void downloadFile(Long id, HttpServletResponse response) {
        lmsEquipFileService.downloadEveFile(response,id);
    }
}
