package com.patzn.lims.equip.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.oss.OssClient;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.equip.dto.LmsEquipCheckManageDTO;
import com.patzn.lims.equip.entity.LmsEquipCheckManage;
import com.patzn.lims.equip.mapper.LmsEquipCheckManageMapper;
import com.patzn.lims.equip.service.ILmsEquipCheckManageService;
import com.patzn.lims.equip.vo.LmsEquipCheckManageVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2017-12-09
 */
@Service
public class LmsEquipCheckManageServiceImpl extends BaseServiceImpl<LmsEquipCheckManageMapper, LmsEquipCheckManage> implements ILmsEquipCheckManageService {
    @Autowired
    private OssClient ossClient;


    @Override
    public Page<LmsEquipCheckManageVO> pageVO(Page<LmsEquipCheckManageVO> page, LmsEquipCheckManageDTO lmsEquipCheckManageDTO) {
        page.setRecords(baseMapper.selectPageVO(page, lmsEquipCheckManageDTO));
        return page;
    }

    @Override
    public List<LmsEquipCheckManageVO> listVO(LmsEquipCheckManageDTO lmsEquipCheckManageDTO) {
        return baseMapper.selectPageVO(lmsEquipCheckManageDTO);
    }

    @Override
    public LmsEquipCheckManageVO getVOById(Long id) {
        return baseMapper.selectVOById(id);
    }

    @Override
    public boolean existByIds(Long[] ids) {
        return super.count(Wrappers.<LmsEquipCheckManage>query().in("check_id", ids)) >= 1;
    }

    @Override
    public LmsEquipCheckManage getOne(Long checkId) {
        return super.getOne(Wrappers.<LmsEquipCheckManage>query().eq("check_id", checkId).last("LIMIT 1"));
    }




}
