package com.patzn.lims.equip.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.Account;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.drug.entity.DrugAptitude;
import com.patzn.lims.equip.entity.LmsEquipClass;
import com.patzn.lims.equip.entity.LmsEquipClassRole;
import com.patzn.lims.equip.mapper.LmsEquipClassRoleMapper;
import com.patzn.lims.equip.service.ILmsEquipClassRoleService;
import com.patzn.lims.equip.service.ILmsEquipClassService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 仪器类别关联角色表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2018-05-14
 */
@Service
public class LmsEquipClassRoleServiceImpl extends BaseServiceImpl<LmsEquipClassRoleMapper, LmsEquipClassRole> implements ILmsEquipClassRoleService {

    @Autowired
    private ILmsEquipClassService lmsEquipClassService;

    @Override
    public Page<LmsEquipClassRole> page(Page<LmsEquipClassRole> page, LmsEquipClassRole lmsEquipClassRole) {
        QueryWrapper<LmsEquipClassRole> wrapper = Wrappers.<LmsEquipClassRole>query(lmsEquipClassRole);
        return this.page(page, wrapper);
    }


    @Override
    public List<LmsEquipClassRole> list(LmsEquipClassRole lmsEquipClassRole) {
        return this.list(Wrappers.<LmsEquipClassRole>query(lmsEquipClassRole));
    }

    @Override
    public Boolean saveRoleRelClass(Long roleId, Long[] classIds) {
        if (null != classIds && classIds.length > 0) {
            // 删除之前关联的内容
            this.remove(Wrappers.<LmsEquipClassRole>query().eq("role_id", roleId));
            return this.saveBatch(Arrays.stream(classIds).map(categoryId -> {
                LmsEquipClassRole lmsEquipClassRole = new LmsEquipClassRole();
                lmsEquipClassRole.setRoleId(roleId);
                lmsEquipClassRole.setClassId(categoryId);
                return lmsEquipClassRole;
            }).collect(Collectors.toList()));
        }
        else{
            // 删除全部权限
           return this.remove(Wrappers.<LmsEquipClassRole>query().eq("role_id", roleId));
        }
        //return false;
    }

    @Override
    public List<LmsEquipClass> listByUserId(Long userId) {
        return lmsEquipClassService.listByUserId(userId);
    }

    @Override
    public List<LmsEquipClass> listIncludeRoleId(Long roleId) {
        return lmsEquipClassService.listIncludeRoleId(roleId);
    }

    @Override
    public List<LmsEquipClass> getClassAllTree(String name) {
        return lmsEquipClassService.getClassAllTree(name);
    }

    @Override
    public List<LmsEquipClass> getClassTree(LmsEquipClass equipClass, Account account) {
        return lmsEquipClassService.getClassTree(equipClass, account);
    }
}
