package com.patzn.lims.equip.service.impl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.common.Tree;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.web.Account;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.core.web.LoginHelper;
import com.patzn.lims.equip.entity.LmsEquipClass;
import com.patzn.lims.equip.mapper.LmsEquipClassMapper;
import com.patzn.lims.equip.service.ILmsEquipClassService;
import com.patzn.lims.equip.vo.LmsEquipClassVO;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 * 仪器分类信息表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2017-11-30
 */
@Service
public class LmsEquipClassServiceImpl extends BaseServiceImpl<LmsEquipClassMapper, LmsEquipClass> implements ILmsEquipClassService {


    @Override
    public Page<LmsEquipClassVO> page(Page<LmsEquipClassVO> page, LmsEquipClassVO lmsEquipClass) {
        lmsEquipClass.setCompanyId(LoginHelper.getAccount().getCompanyId());
        if (null != lmsEquipClass.getId()) {
            // 递归分页情况
            return pageRecursive(page, lmsEquipClass);
        }
        return page.setRecords(baseMapper.selectEquipClass(page,lmsEquipClass));
    }


    @Override
    public Page<LmsEquipClassVO> pageRecursive(Page<LmsEquipClassVO> page, LmsEquipClassVO lmsEquipClass) {
        lmsEquipClass.setCompanyId(LoginHelper.getAccount().getCompanyId());
        return page.setRecords(baseMapper.selectPageRecursive(page, lmsEquipClass));
    }


    @Override
    public List<LmsEquipClassVO> listRecursive(LmsEquipClassVO lmsEquipClass){
        return  baseMapper.selectPageRecursive(lmsEquipClass);
    }

    @Override
    public List<LmsEquipClass> list(LmsEquipClass lmsEquipClass) {
        //modify reanson 获取用户对应权限类别列表
        QueryWrapper<LmsEquipClass> wrapper = Wrappers.<LmsEquipClass>query(lmsEquipClass);
        if (null != lmsEquipClass.getName()){
            wrapper.like("name", lmsEquipClass.getName());
            lmsEquipClass.setName(null);
        }
        wrapper.eq("company_id", LoginHelper.getAccount().getCompanyId());
        return list(wrapper);
       // return baseMapper.selectClassList(lmsEquipClass.getName(), LoginHelper.getAccount());
    }

    @Override
    public LmsEquipClassVO getVOById(Long id) {
        return baseMapper.selectVOById(id);
    }

    @Override
    public boolean updateById(LmsEquipClass entity) {
        //判断父层级的正确性
        PtAssert.fail(entity.getPid().equals(entity.getId()), "抱歉!上级分类不能选自己!");
        return super.updateById(entity);
    }

    @Override
    public boolean existByIds(Long[] ids) {
        return super.count(Wrappers.<LmsEquipClass>query().in("pid", ids)) >= 1;
    }


    @Transactional(rollbackFor = Exception.class)
    @Override
    public Boolean removeByIds(Long[] ids) {
        if (existByIds(ids)) {
            PtAssert.fail("选中数据存在子类，无法删除！");
        }

        return super.remove(Wrappers.<LmsEquipClass>query().in("id", ids));
    }

    @Override
    public List<LmsEquipClass> getClassAllTree(String name) {
        if(StringUtils.isBlank(name)){
            return list(Wrappers.<LmsEquipClass>query().select("id,pid,name").eq("company_id", LoginHelper.getAccount().getCompanyId()).notExists(StringUtils.isNoneEmpty(name),"select 1 from lms_equip_class t where t.pid =lms_equip_class.id"));
        }
        return baseMapper.selectClassAllTree(name);

    }

    @Override
    public List<LmsEquipClass> listByNames(Collection<?> names) {
        if (CollectionUtils.isEmpty(names)){
            List<LmsEquipClass> list=new ArrayList<>();
            return  list;
        }
        return super.list(Wrappers.<LmsEquipClass>query().in("name", names).eq("company_id", LoginHelper.getAccount().getCompanyId()));
    }

    @Override
    public List<LmsEquipClass> getClassTree(LmsEquipClass equipClass, Account account) {
        return baseMapper.selectClassTree(equipClass, account);
    }

    @Override
    public List<LmsEquipClass> listIncludeRoleId(Long roleId) {
        return baseMapper.selectIncludeRoleId(roleId);
    }

    @Override
    public List<LmsEquipClass> listByUserId(Long userId) {
        return baseMapper.selectByUserId(userId);
    }


    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean saveClass(LmsEquipClass lmsEquipClass) {
        PtAssert.fail(addCheckRepeat(lmsEquipClass.getName()),"类别名不能与已有的重复，请确认");
        return super.save(lmsEquipClass);
    }


    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean updateClassById(LmsEquipClass lmsEquipClass) {
        PtAssert.fail(null==lmsEquipClass.getId(),"id不能为空");
        int count=super.count(Wrappers.<LmsEquipClass>query().eq("name",lmsEquipClass.getName()).ne("id",lmsEquipClass.getId()));
        if (count>0){
            PtAssert.fail("类别名不能与已有的重复，请确认");
        }
        return updateById(lmsEquipClass);
    }

    @Override
    public Set<String> getAllClassName() {
        List<LmsEquipClass> classList = super.list(Wrappers.<LmsEquipClass>query().select("name").eq("company_id", LoginHelper.getAccount().getCompanyId()));
        Set<String> nameSet = classList.stream().filter(lmsEquipClass -> StringUtils.isNotBlank(lmsEquipClass.getName())).map(lmsEquipClass -> lmsEquipClass.getName()).collect(Collectors.toSet());
        return nameSet;
    }

    @Override
    public boolean importEquipClass(MultipartFile file) {
//        Collection<EquipClassETO> etos = ExcelUtils.readSheetAtOne(EquipClassETO.class, file, "仪器类别导入失败");
//        if (CollectionUtils.isEmpty(etos)) {
//            return false;
//        }
//
//        // 重复验证
//        //Set<String> nameSet = etos.stream().map(e -> e.getName()).collect(toSet());
//        //RestAssert.fail(etos.size() != nameSet.size(), "分类名称存在重复，请重新整理后导入");
//
//        //查询出所有的类别信息
//        List<LmsEquipClass> dbList = super.list(Condition.create());
//        Map<String, LmsEquipClass> dbMap = new HashMap<>();
//        for(LmsEquipClass equipClass : dbList){
//            if(!dbMap.containsKey(equipClass.getName())){
//                dbMap.put(equipClass.getName(),equipClass);
//            }
//        }
//        // 数据库有效验证
//        int num = 2;
//        for(EquipClassETO eto : etos){
//            RestAssert.fail(dbMap.containsKey(eto.getName().trim()),
//                    "第"+num+"行类别名称已存在，请重新整理后导入");
//            num++;
//        }
//
//
//        // 循环处理数据
//        List<LmsEquipClass> list = new ArrayList<>();
//        int count = 2;
//        StringBuilder sb = new StringBuilder();
//        for(EquipClassETO eto : etos){
//            LmsEquipClass equipClass = new LmsEquipClass();
//            Long lastId = null;
//            if(StringUtils.isBlank(eto.getParent())){
//                equipClass.setId(IdWorker.getId());
//                equipClass.setPid(0L);
//                equipClass.setName(eto.getName().trim());
//                equipClass.setRemark(eto.getRemark());
//                boolean listBl = true;
//                if (CollectionUtils.isNotEmpty(list)) {
//                    for(LmsEquipClass saveClass : list){
//                        if(saveClass.getName().equals(eto.getName().trim())){
//                            listBl = false;
//                            break;
//                        }
//                    }
//                }
//                if(listBl){
//                    list.add(equipClass);
//                }
//            }else{
//                String parent = eto.getParent().trim();
//                String[] names = parent.replace("\r\n", "").split("/");
//                if (null == names || names.length == 0) {
//                    continue;
//                }
//                List<String> nameList = Arrays.asList(names);
//                LmsEquipClass classParent = new LmsEquipClass();
//                LmsEquipClass classUp = new LmsEquipClass();
//                for(int i = 0;i<nameList.size();i++){
//                    //看name在数据库有没有
//                    if(i == 0){
//                        if(dbMap.containsKey(nameList.get(i).trim()) && dbMap.get(nameList.get(i)).getPid().longValue() == 0L){
//                            //存在数据库且pid=0
//                            classParent = dbMap.get(nameList.get(i).trim());
//                            lastId = classParent.getId();
//                        }else if(dbMap.containsKey(nameList.get(i).trim()) && dbMap.get(nameList.get(i)).getPid().longValue() != 0L){
//                            //存在数据库但pid！=0
//                            sb.append("第" + count + "行，上级类别未从第一级开始填写 ");
//                            break;
//                        }else if(!dbMap.containsKey(nameList.get(i).trim())){
//                            //不存在于数据库
//                            //看name在list有没有
//                            boolean bl = false;
//                            for(LmsEquipClass tempClass : list){
//                                if(Objects.equals(tempClass.getName(),nameList.get(i).trim()) && Objects.equals(tempClass.getPid().longValue(),0L)){
//                                    classParent = tempClass;
//                                    lastId = classParent.getId();
//                                    bl = true;
//                                    break;
//                                }
//                            }
//                            if(!bl){
//                                boolean bl2 = false;
//                                for(LmsEquipClass tempClass : list){
//                                    if(Objects.equals(tempClass.getName(),nameList.get(i).trim()) && !Objects.equals(tempClass.getPid().longValue(),0L)){
//                                        sb.append("第" + count + "行，所填上级类别的一级类别存在excel，不是一级类别 ");
//                                        bl2 = true;
//                                        break;
//                                    }
//                                }
//                                if(bl2){
//                                    break;
//                                }
//                                //不存在于list的情况
//                                classParent.setId(IdWorker.getId());
//                                classParent.setPid(0L);
//                                classParent.setName(nameList.get(i).trim());
//                                lastId = classParent.getId();
//                                boolean listBl = true;
//                                if (CollectionUtils.isNotEmpty(list)) {
//                                    for(LmsEquipClass saveClass : list){
//                                        if(saveClass.getName().equals(nameList.get(i).trim())){
//                                            listBl = false;
//                                            break;
//                                        }
//                                    }
//                                }
//                                if(listBl) {
//                                    list.add(classParent);
//                                }
//                            }
//                        }
//                    }else{
//                        //能进入这里说明一级类别已经成功添加到list或取到于list或取到于数据库
//                        LmsEquipClass classParentCurr = new LmsEquipClass();
//                        if(dbMap.containsKey(nameList.get(i).trim()) && dbMap.get(nameList.get(i)).getPid().longValue() == 0L){
//                            //存在数据库且pid=0
//                            sb.append("第" + count + "行，上级类别的非第一级类别:"+nameList.get(i)+"已存在于系统中为一级类别 ");
//                            break;
//                        }else if(dbMap.containsKey(nameList.get(i).trim()) && dbMap.get(nameList.get(i)).getPid().longValue() != 0L){
//                            //存在数据库但pid!=0
//                            //如果pid跟上面的或classUp的一样，则取该数据库中的这条，如果不一样则报错
//                            if(dbMap.get(nameList.get(i)).getPid().longValue() == classParent.getId()
//                                    || (null != classUp && null != classUp.getId()) ? dbMap.get(nameList.get(i)).getPid().longValue() == classUp.getId() : false){
//                                classParentCurr = dbMap.get(nameList.get(i).trim());
//                                classUp = classParentCurr;
//                                lastId = classParentCurr.getId();
//                            }else {
//                                sb.append("第" + count + "行，上级类别的非第一级类别:"+nameList.get(i)+"已存在于系统中 ");
//                                break;
//                            }
//                        }else if(!dbMap.containsKey(nameList.get(i).trim())){
//                            //不存在于数据库
//                            //看name在list有没有
//                            boolean bl = false;
//                            for(LmsEquipClass tempClass : list){
//                                if(Objects.equals(tempClass.getName(),nameList.get(i).trim()) && !Objects.equals(tempClass.getPid().longValue(),0L)){
//                                    classParentCurr = tempClass;
//                                    classUp = classParentCurr;
//                                    lastId = classParentCurr.getId();
//                                    bl = true;
//                                    break;
//                                }
//                            }
//                            if(!bl){
//                                boolean bl2 = false;
//                                for(LmsEquipClass tempClass : list){
//                                    if(Objects.equals(tempClass.getName(),nameList.get(i).trim()) && Objects.equals(tempClass.getPid().longValue(),0L)){
//                                        sb.append("第" + count + "行，所填上级类别的非第一级类别:"+nameList.get(i)+"已存在excel，是一级类别 ");
//                                        bl2 = true;
//                                        break;
//                                    }
//                                }
//                                if(bl2){
//                                    break;
//                                }
//                                //不存在于list的情况
//                                classParentCurr.setId(IdWorker.getId());
//                                //查找数据库或list中该类别的上级类别
//                                if(i==1){
//                                    classParentCurr.setPid(classParent.getId());
//                                }else{
//                                    String nameUp = nameList.get(i-1).trim();
//                                    classParentCurr.setPid(classUp.getId());
//                                }
//                                classParentCurr.setName(nameList.get(i).trim());
//                                classUp = classParentCurr;
//                                lastId = classParentCurr.getId();
//                                boolean listBl = true;
//                                if (CollectionUtils.isNotEmpty(list)) {
//                                    for(LmsEquipClass saveClass : list){
//                                        if(saveClass.getName().equals(nameList.get(i).trim())){
//                                            listBl = false;
//                                            break;
//                                        }
//                                    }
//                                }
//                                if(listBl) {
//                                    list.add(classParentCurr);
//                                }
//                            }
//                        }
//                    }
//                }
//            }
//            if(null == lastId){
//                //说明上级类别有报错或者没填上级类别
//                continue;
//            }else{
//                equipClass.setId(IdWorker.getId());
//                equipClass.setPid(lastId);
//                equipClass.setName(eto.getName().trim());
//                equipClass.setRemark(eto.getRemark());
//                boolean listBl = true;
//                if (CollectionUtils.isNotEmpty(list)) {
//                    for(LmsEquipClass saveClass : list){
//                        if(saveClass.getName().equals(eto.getName().trim())){
//                            listBl = false;
//                            break;
//                        }
//                    }
//                }
//
//                if(listBl) {
//                    list.add(equipClass);
//                }
//            }
//            count++;
//        }
//
//        if(null != sb && sb.toString().length() > 0){
//            RestAssert.fail(sb.toString());
//        }
//        // 批量保存
//        if(CollectionUtils.isNotEmpty(list)){
//            super.saveBatch(list);
//        }
        return true;

    }

    @Override
    public List<Tree> getTree(LmsEquipClass lmsEquipClass) {
        return baseMapper.selectTree(lmsEquipClass, false);
    }

    public boolean  addCheckRepeat(String name){
        PtAssert.fail(StringUtils.isBlank(name),"类别名称不能为空");
        return super.count(Wrappers.<LmsEquipClass>query().eq("name", name).eq("company_id", LoginHelper.getAccount().getCompanyId())) > 0;
    }

    public boolean  editCheckRepeat(Long id,String name){
        PtAssert.fail(StringUtils.isBlank(name),"类别名称不能为空");
        return  super.count(Wrappers.<LmsEquipClass>query().eq("name",name).ne("id",id))>0;
    }

}
