package com.patzn.lims.equip.service.impl;

import com.patzn.lims.core.oss.OssClient;
import com.patzn.lims.core.oss.OssFileResult;
import com.patzn.lims.equip.entity.LmsEquipFile;
import com.patzn.lims.equip.mapper.LmsEquipFileMapper;
import com.patzn.lims.equip.service.ILmsEquipFileService;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

import static java.util.stream.Collectors.toList;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author wwd
 * @since 2020-03-28
 */
@Service
public class LmsEquipFileServiceImpl extends BaseServiceImpl<LmsEquipFileMapper, LmsEquipFile> implements ILmsEquipFileService {

    @Autowired
    private OssClient ossClient;

    @Override
    public Page<LmsEquipFile> page(Page<LmsEquipFile> page, LmsEquipFile lmsEquipFile) {
        QueryWrapper<LmsEquipFile> wrapper = Wrappers.<LmsEquipFile>query(lmsEquipFile);
        return this.page(page, wrapper);
    }

    @Override
    public List<LmsEquipFile> list(LmsEquipFile lmsEquipFile) {
        return list(Wrappers.<LmsEquipFile>query(lmsEquipFile));
    }



    @Override
    public LmsEquipFile saveAndUpload(MultipartFile file, String bucketName, String foldPath, Long relId, Integer type) {
        OssFileResult result = ossClient.upload(file);
        if (null == result) {
            return null;
        }
        LmsEquipFile lmsEquipFile = new LmsEquipFile();
        lmsEquipFile.setRelId(relId);
        lmsEquipFile.setOrginName(file.getOriginalFilename());
        lmsEquipFile.setFilePath(result.getObjectKey());
        lmsEquipFile.setType(type);
        save(lmsEquipFile);
        return lmsEquipFile;
    }


    @Override
    public boolean deleteBatch(Long[] ids) {
        List<LmsEquipFile> equipFileList = list(Wrappers.<LmsEquipFile>query().in("id", ids));
        if (CollectionUtils.isEmpty(equipFileList)) {
            return false;
        }

        ossClient.deleteObjects(equipFileList.stream().map(e -> e.getFilePath()).collect(toList()));
        return remove(Wrappers.<LmsEquipFile>query().in("id", ids));
    }


    @Override
    public void downloadFile(HttpServletResponse response, String bucket, String fileName, String orgFileName) {
        ossClient.download(fileName, orgFileName, response);
    }


    @Override
    public LmsEquipFile addAndUpload(MultipartFile file, String bucketName, String foldPath, Long relId, Integer type) {
        QueryWrapper<LmsEquipFile> wrapper = Wrappers.<LmsEquipFile>query();
        LmsEquipFile lmsEquipFile = this.getOne(wrapper.eq("rel_id", relId));
        OssFileResult result = ossClient.upload(file);
        if (lmsEquipFile != null) {
            //以前存过就先删掉
            if (StringUtil.isNotBlank(lmsEquipFile.getFilePath())) {
                ossClient.deleteObject(lmsEquipFile.getFilePath());
            }
            lmsEquipFile.setRelId(relId);
            lmsEquipFile.setOrginName(file.getOriginalFilename());
            lmsEquipFile.setFilePath(result.getObjectKey());
            lmsEquipFile.setType(type);
            saveOrUpdate(lmsEquipFile);
            return lmsEquipFile;
        } else {
            LmsEquipFile nlmsEquipFile = new LmsEquipFile();
            nlmsEquipFile.setRelId(relId);
            nlmsEquipFile.setOrginName(file.getOriginalFilename());
            nlmsEquipFile.setFilePath(result.getObjectKey());
            nlmsEquipFile.setType(type);
            save(nlmsEquipFile);
            return nlmsEquipFile;
        }


    }

    @Override
    public void downloadEveFile(HttpServletResponse servletResponse, Long relid) {
        QueryWrapper<LmsEquipFile> wrapper = Wrappers.<LmsEquipFile>query();
        LmsEquipFile lmsEquipFile = this.getOne(wrapper.eq("rel_id", relid));
        ossClient.download(lmsEquipFile.getFilePath(), lmsEquipFile.getOrginName(), servletResponse);
    }

}
