package com.patzn.lims.equip.service.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.web.Account;
import com.patzn.lims.core.web.LoginHelper;
import com.patzn.lims.equip.dto.LmsEquipInfoDTO;
import com.patzn.lims.equip.entity.LmsEquipClass;
import com.patzn.lims.equip.entity.LmsEquipInfo;
import com.patzn.lims.equip.entity.LmsEquipPurchaseDetail;
import com.patzn.lims.equip.enums.EquipDataStatusEnum;
import com.patzn.lims.equip.mapper.LmsEquipInfoMapper;
import com.patzn.lims.equip.service.ILmsEquipClassService;
import com.patzn.lims.equip.service.ILmsEquipInfoService;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.equip.service.ILmsEquipPurchaseDetailService;
import com.patzn.lims.equip.vo.LmsEquipClassVO;
import com.patzn.lims.equip.vo.LmsEquipInfoVO;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author wwd
 * @since 2020-03-16
 */
@Service
public class LmsEquipInfoServiceImpl extends BaseServiceImpl<LmsEquipInfoMapper, LmsEquipInfo> implements ILmsEquipInfoService {

    @Autowired
    private ILmsEquipClassService lmsEquipClassService;
    @Autowired
    private ILmsEquipPurchaseDetailService lmsEquipPurchaseDetailService;

    @Override
    public Page<LmsEquipInfoVO> page(Page<LmsEquipInfoVO> page, LmsEquipInfoDTO lmsEquipInfoDTO) {
        lmsEquipInfoDTO.setTempStatus(EquipDataStatusEnum.REAL.getValue());
        lmsEquipInfoDTO.setCompanyId(LoginHelper.getAccount().getCompanyId());
        return page.setRecords(baseMapper.selectPageVO(page, LoginHelper.getAccount(), lmsEquipInfoDTO));
    }

    @Override
    public Page<LmsEquipInfoVO> pageVO(Page page, LmsEquipInfoVO lmsEquipInfoVO) {
        lmsEquipInfoVO.setCompanyId(LoginHelper.getAccount().getCompanyId());
        if (null != lmsEquipInfoVO.getId()) {
            // 递归分页情况
            LmsEquipClassVO lmsEquipClass=  new LmsEquipClassVO();
            lmsEquipClass.setId(lmsEquipInfoVO.getId());
            lmsEquipClass.setCompanyId(lmsEquipInfoVO.getCompanyId());
            List<LmsEquipClassVO> list= lmsEquipClassService.listRecursive(lmsEquipClass);
            if (CollectionUtils.isEmpty(list)){
               return page;

            }
            List<Long> classIds = list.stream().map(i->{
                return  i.getId();
            }).collect(Collectors.toList());
            lmsEquipInfoVO.setClassIds(classIds);

            return pageRecursive(page, lmsEquipInfoVO);
        }
        return pageRecursive(page, lmsEquipInfoVO);
    }

    @Override
    public LmsEquipInfoVO getVO(Long id) {
        LmsEquipInfo info=  getById(id);
        LmsEquipInfoVO vo=   info.convert(LmsEquipInfoVO.class);

        LmsEquipClass equipClass=  lmsEquipClassService.getById(info.getClassId());
        vo.setClassName(equipClass.getName());
        return vo;
    }

    @Override
    public boolean addDetail(LmsEquipPurchaseDetail lmsEquipPurchaseDetail, Account account) {
        PtAssert.fail(StringUtils.isBlank(lmsEquipPurchaseDetail.getRelatedStandards()), "请填写相关标准");
        if (null == lmsEquipPurchaseDetail.getProductId()) {
            //如果是手动添加产品信息，那么就直接保存
            //添加供应商验证
            lmsEquipPurchaseDetailService.validExsitSupper(lmsEquipPurchaseDetail.getSupplierName());
            lmsEquipPurchaseDetailService.save(lmsEquipPurchaseDetail);
        } else {
            //如果是选择产品信息，那么需要去重
            LmsEquipPurchaseDetail query = new LmsEquipPurchaseDetail();
            query.setPurchaseId(lmsEquipPurchaseDetail.getPurchaseId());
            query.setProductId(lmsEquipPurchaseDetail.getProductId());
            List<LmsEquipPurchaseDetail> detailList = lmsEquipPurchaseDetailService.list(Wrappers.<LmsEquipPurchaseDetail>query(query));

            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(detailList)) {
                //如果存在一条重复数据，那么数量相加
                Integer totalCounts = detailList.get(0).getCounts() + lmsEquipPurchaseDetail.getCounts();
                lmsEquipPurchaseDetail.setCounts(totalCounts);
                lmsEquipPurchaseDetail.setId(detailList.get(0).getId());
                //添加供应商验证
                lmsEquipPurchaseDetailService.validExsitSupper(lmsEquipPurchaseDetail.getSupplierName());
                lmsEquipPurchaseDetailService.updateById(lmsEquipPurchaseDetail);
            } else {
                //如果没有重复，直接添加
                lmsEquipPurchaseDetailService.validExsitSupper(lmsEquipPurchaseDetail.getSupplierName());
                lmsEquipPurchaseDetail.setId(IdWorker.getId());
                lmsEquipPurchaseDetailService.save(lmsEquipPurchaseDetail);
            }
        }
        return true;
    }

    private Page<LmsEquipInfoVO> pageRecursive(Page page, LmsEquipInfoVO lmsEquipInfoVO) {
        lmsEquipInfoVO.setCompanyId(LoginHelper.getAccount().getCompanyId());
        return baseMapper.selectPageRecursive(page, lmsEquipInfoVO);
    }
}
