package com.patzn.lims.equip.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.common.Tree;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.equip.entity.LmsEquipLocation;
import com.patzn.lims.equip.mapper.LmsEquipLocationMapper;
import com.patzn.lims.equip.service.ILmsEquipLocationService;
import com.patzn.lims.equip.vo.LmsEquipLocationVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * <p>
 * 仪器位置信息表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2017-12-16
 */
@Service
public class LmsEquipLocationServiceImpl extends BaseServiceImpl<LmsEquipLocationMapper, LmsEquipLocation> implements ILmsEquipLocationService {


    @Override
    public Page<LmsEquipLocationVO> pageVO(Page<LmsEquipLocationVO> page, LmsEquipLocationVO lmsEquipLocationVO) {

        if(StringUtils.isNotBlank(lmsEquipLocationVO.getKeyword())){
            lmsEquipLocationVO.setName(lmsEquipLocationVO.getKeyword());
        }
        if (null != lmsEquipLocationVO.getId()) {
            // 递归分页情况
            return pageRecursive(page, lmsEquipLocationVO);
        }
        page.setRecords(baseMapper.selectPageVO(page, lmsEquipLocationVO));
        return page;
    }

    @Override
    public Page<LmsEquipLocationVO> pageRecursive(Page<LmsEquipLocationVO> page, LmsEquipLocationVO lmsEquipLocationVO) {
        return page.setRecords(baseMapper.selectPageRecursive(page, lmsEquipLocationVO));
    }

    @Override
    public List<LmsEquipLocationVO> listVO(LmsEquipLocationVO lmsEquipLocationVO) {
        return baseMapper.selectPageVO(lmsEquipLocationVO);
    }

    @Override
    public List<Tree> getTree(LmsEquipLocation lmsEquipLocation) {
        return baseMapper.selectTree(lmsEquipLocation, false);
    }

    @Override
    public LmsEquipLocationVO getVOById(Long id) {
        return baseMapper.selectVOById(id);
    }

    @Override
    public boolean uploadFile(MultipartFile file, LmsEquipLocation lmsEquipLocation) {
//        OssFileResult result = ossClient.upload(file);
//        if (null != result) {
//            //先删除原文件
//            Long id = lmsEquipLocation.getId();
//            LmsEquipLocation location = getById(id);
//            if (StringUtils.isNotBlank(location.getImagePath())) {
//                ossClient.deleteObject(location.getImagePath());
//            }
//
//            location.setImagePath(result.getObjectKey());
//            updateById(location);
//        }

        return true;
    }

    @Override
    public boolean deleteFile(Long id) {
        LmsEquipLocation location = getById(id);
//        ossClient.deleteObject(location.getImagePath());
//        location.setImagePath(null);
        return updateById(location);
    }

    @Override
    public List<LmsEquipLocation> listByNames(Collection<?> names) {
        if (CollectionUtils.isEmpty(names)) {
            List<LmsEquipLocation> list = new ArrayList<>();
            return list;
        }

        return super.list(Wrappers.<LmsEquipLocation>query().in("name", names));
    }

    @Override
    public Set<String> getAllPosition() {
        List<LmsEquipLocation> locationList = super.list(Wrappers.<LmsEquipLocation>query().select("name"));
        Set<String> nameSet = locationList.stream().filter(location -> StringUtils.isNotBlank(location.getName())).map(location -> location.getName()).collect(Collectors.toSet());
        return nameSet;
    }

    @Override
    public boolean save(LmsEquipLocation lmsEquipLocation){
        //判断名称是否重复
        PtAssert.fail(validEquiplocation(lmsEquipLocation),"位置名称不能重复,请重新定义位置名称!");
        return super.save(lmsEquipLocation);
    }
    @Override
    public boolean updateById(LmsEquipLocation lmsEquipLocation){
        //判断父层级的正确性
        PtAssert.fail(lmsEquipLocation.getPid().equals(lmsEquipLocation.getId()), "抱歉!上级位置不能选自己!");
        //判断名称是否重复
        PtAssert.fail(validEquiplocation(lmsEquipLocation),"位置名称不能重复,请重新定义位置名称!");
        return super.updateById(lmsEquipLocation);
    }


    private boolean validEquiplocation(LmsEquipLocation lmsEquipLocation){
        //新添加验证是否存在
        if(lmsEquipLocation.getId() == null){
            return  super.count(Wrappers.<LmsEquipLocation>query().eq("name",lmsEquipLocation.getName())) >0 ;
        }
        else {
            //修改时
            List<LmsEquipLocation> lstLmsEquipLocation = super.list(Wrappers.<LmsEquipLocation>query().eq("name", lmsEquipLocation.getName()));
            if(lstLmsEquipLocation != null &&  lstLmsEquipLocation.size() > 1){
               return true;
            }
            else if(lstLmsEquipLocation != null &&  lstLmsEquipLocation.size() ==1){
                LmsEquipLocation el = lstLmsEquipLocation.get(0);
                if(el != null && el.getId().equals(lmsEquipLocation.getId()) ){
                    return false;
                }
                return true;
            }
            return false;
        }
    }

}
