package com.patzn.lims.equip.service.impl;

import com.google.common.collect.Lists;
import com.patzn.lims.equip.entity.LmsEquipLog;
import com.patzn.lims.equip.mapper.LmsEquipLogMapper;
import com.patzn.lims.equip.service.ILmsEquipLogService;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 仪器日志表 服务实现类
 * </p>
 *
 * @author wwd
 * @since 2020-03-28
 */
@Service
public class LmsEquipLogServiceImpl extends BaseServiceImpl<LmsEquipLogMapper, LmsEquipLog> implements ILmsEquipLogService {

    @Override
    public Page<LmsEquipLog> page(Page<LmsEquipLog> page, LmsEquipLog lmsEquipLog) {
        QueryWrapper<LmsEquipLog> wrapper = Wrappers.<LmsEquipLog>query(lmsEquipLog);
        return this.page(page, wrapper);
    }

    private List<Date> getPeriodDate(Date startDate, Date endDate) {
        List lDate = new ArrayList();
        lDate.add(startDate);
        Calendar calBegin = Calendar.getInstance();
        calBegin.setTime(startDate);
        Calendar calEnd = Calendar.getInstance();
        calEnd.setTime(endDate);
        while (endDate.after(calBegin.getTime())) {
            calBegin.add(Calendar.DAY_OF_MONTH, 1);
            lDate.add(calBegin.getTime());
        }

        return lDate;
    }

    @Override
    public boolean saveLogs(Date startTime, Date endTime, Long equipId, Long relId, Integer status, Integer type, String ...param) {
        List<LmsEquipLog> logs = Lists.newArrayList();
        try {
            //保存日志信息
            Date startDate = DateTime.parse(new DateTime(startTime).toString("yyyy-MM-dd"), DateTimeFormat.forPattern("yyyy-MM-dd")).toDate();
            Date endDate = DateTime.parse(new DateTime(endTime).toString("yyyy-MM-dd"), DateTimeFormat.forPattern("yyyy-MM-dd")).toDate();

            List<Date> dates = getPeriodDate(startDate, endDate);
            for (int i = 0; i < dates.size(); i++) {
                String dateStr = new DateTime(dates.get(i)).toString("yyyy-MM-dd");
                LmsEquipLog log = new LmsEquipLog();
                log.setEquipId(equipId);
                log.setStatus(status);
                log.setType(type);
                log.setRelId(relId);
                log.setOperateDate(dates.get(i));
                String context = param!=null?"":param[0];
                if (i == 0) {
                    log.setStartTime(startTime);
                } else {
                    log.setStartTime(DateTime.parse(dateStr + " 00:00:00", DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss")).toDate());
                }

                if (i == (dates.size() - 1)) {
                    log.setEndTime(endTime);
                } else {
                    log.setEndTime(DateTime.parse(dateStr + " 23:59:59", DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss")).toDate());
                }

                logs.add(log);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        return saveBatch(logs);
    }
}
