package com.patzn.lims.equip.service.impl;

import com.patzn.lims.equip.entity.LmsEquipMaintainDetail;
import com.patzn.lims.equip.mapper.LmsEquipMaintainDetailMapper;
import com.patzn.lims.equip.service.ILmsEquipMaintainDetailService;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.equip.vo.LmsEquipMaintainDetailVO;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 仪器保养计划详情信息表 服务实现类
 * </p>
 *
 * @author wwd
 * @since 2020-03-28
 */
@Service
public class LmsEquipMaintainDetailServiceImpl extends BaseServiceImpl<LmsEquipMaintainDetailMapper, LmsEquipMaintainDetail> implements ILmsEquipMaintainDetailService {


    @Override
    public Page<LmsEquipMaintainDetailVO> pageVO(Page<LmsEquipMaintainDetailVO> page, LmsEquipMaintainDetailVO lmsEquipMaintainDetailVO) {
        page.setRecords(baseMapper.selectPageVO(page, lmsEquipMaintainDetailVO));
        return page;
    }


    @Override
    public Page<LmsEquipMaintainDetail> page(Page<LmsEquipMaintainDetail> page, LmsEquipMaintainDetail lmsEquipMaintainDetail) {
        QueryWrapper<LmsEquipMaintainDetail> wrapper = Wrappers.<LmsEquipMaintainDetail>query(lmsEquipMaintainDetail);
        return this.page(page, wrapper);
    }


    @Override
    public List<LmsEquipMaintainDetailVO> listVO(LmsEquipMaintainDetailVO lmsEquipMaintainDetailVO) {
        return baseMapper.selectPageVO(lmsEquipMaintainDetailVO);
    }


    @Override
    public LmsEquipMaintainDetailVO getVOById(Long id) {
        return baseMapper.selectVOById(id);
    }
}
