package com.patzn.lims.equip.service.impl;

import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.web.LoginHelper;
import com.patzn.lims.equip.dto.LmsEquipMaintainDTO;
import com.patzn.lims.equip.dto.LmsEquipMaintainManageVO;
import com.patzn.lims.equip.entity.LmsEquipMaintain;
import com.patzn.lims.equip.entity.LmsEquipMaintainHistory;
import com.patzn.lims.equip.entity.LmsEquipMaintainManage;
import com.patzn.lims.equip.mapper.LmsEquipMaintainManageMapper;
import com.patzn.lims.equip.service.*;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.equip.vo.LmsEquipMaintainDetailVO;
import com.patzn.lims.res.service.ILmsPropertyService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author wwd
 * @since 2020-03-28
 */
@Service
public class LmsEquipMaintainManageServiceImpl extends BaseServiceImpl<LmsEquipMaintainManageMapper, LmsEquipMaintainManage> implements ILmsEquipMaintainManageService {

    @Autowired
    private ILmsEquipMaintainDetailService lmsEquipMaintainDetailService;
    @Autowired
    private ILmsEquipLogService lmsEquipLogService;
    @Autowired
    private ILmsEquipInfoService lmsEquipInfoService;
    @Autowired
    private ILmsEquipMaintainHistoryService lmsEquipMaintainHistoryService;
    @Autowired
    private ILmsEquipMaintainService lmsEquipMaintainService;
    @Autowired
    private ILmsPropertyService lmsPropertyService;

    @Override
    public Page<LmsEquipMaintainManage> page(Page<LmsEquipMaintainManage> page, LmsEquipMaintainManage lmsEquipMaintainManage) {
        QueryWrapper<LmsEquipMaintainManage> wrapper = Wrappers.<LmsEquipMaintainManage>query(lmsEquipMaintainManage);
        return this.page(page, wrapper);
    }


    @Override
    public Page<LmsEquipMaintainManageVO> pageVO(Page<LmsEquipMaintainManageVO> page, LmsEquipMaintainManageVO lmsEquipMaintainManageVO) {
        page.setRecords(baseMapper.selectPageVO(page, lmsEquipMaintainManageVO));
        return page;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean add(LmsEquipMaintainDTO lmsEquipMaintainManage) {
        PtAssert.fail(null==lmsEquipMaintainManage.getLmsEquipMaintain().getId(), "找不到主委托单");
        PtAssert.fail(0==lmsEquipMaintainManage.getManageList().size(),"没有实施的数据");
        StringBuilder stringBuilder = new StringBuilder();
        lmsEquipMaintainManage.getManageList().stream().forEach(dto->{
            if(null!=dto.getMaintainStartTimeAct()&&null!=dto.getMaintainEndTimeAct()){
                PtAssert.fail(dto.getMaintainStartTimeAct().after(dto.getMaintainEndTimeAct()),"开始时间不能大于结束时间");
            }
            PtAssert.fail(null==dto.getDetailId(),"找不到维保详情单");
            LmsEquipMaintainDetailVO detailVO = lmsEquipMaintainDetailService.getVOById(dto.getDetailId());
            PtAssert.fail(null==detailVO,"此条信息不存在");
            LmsEquipMaintainManage lmsOld=super.getOne(Wrappers.<LmsEquipMaintainManage>query().eq("detail_id",dto.getDetailId()));
            LmsEquipMaintainManage newDto =dto.convert(LmsEquipMaintainManage.class);

            if(null!=lmsOld){
                newDto.setId(lmsOld.getId());
                stringBuilder.append(lmsPropertyService.getCompareTimeFormatDifferent(newDto, lmsOld, "仪器保养实施对比", detailVO.getLabNum()+detailVO.getName()+":"));
                super.updateById(newDto);
            }else {
                stringBuilder.append(lmsPropertyService.getCompareTimeFormatDifferent(newDto, new LmsEquipMaintainManage() , "仪器保养实施对比", ""+detailVO.getLabNum()+detailVO.getName()+":"));
                super.save(newDto);
            }

        });
        LmsEquipMaintain lmsEquipMaintain = lmsEquipMaintainService.getById(lmsEquipMaintainManage.getLmsEquipMaintain().getId());
        PtAssert.fail(null==lmsEquipMaintain,"主保养单已被删除");
        LmsEquipMaintainHistory lmsEquipMaintainHistory = new LmsEquipMaintainHistory();
        lmsEquipMaintainHistory.setMaintainId(lmsEquipMaintain.getId());
        lmsEquipMaintainHistory.setName(lmsEquipMaintain.getName());
        lmsEquipMaintainHistory.setNum(lmsEquipMaintain.getNum());
        lmsEquipMaintainHistory.setUname(LoginHelper.getAccount().getUserName());
        lmsEquipMaintainHistory.setType(1);
        lmsEquipMaintainHistory.setOperation("修改");
        if(StringUtils.isNotBlank(stringBuilder)){
            lmsEquipMaintainHistory.setDetails(stringBuilder.toString());
            lmsEquipMaintainHistoryService.save(lmsEquipMaintainHistory);
        }

        return true;

    }

}
