package com.patzn.lims.equip.service.impl;

import com.patzn.lims.equip.entity.LmsEquipPurchaseDetail;
import com.patzn.lims.equip.mapper.LmsEquipPurchaseDetailMapper;
import com.patzn.lims.equip.service.ILmsEquipPurchaseDetailService;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.equip.vo.LmsEquipPurchaseDetailVO;
import com.patzn.lims.res.entity.LmsSupplier;
import com.patzn.lims.res.service.ILmsSupplierService;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 仪器采购详情信息表 服务实现类
 * </p>
 *
 * @author wwd
 * @since 2020-03-27
 */
@Service
public class LmsEquipPurchaseDetailServiceImpl extends BaseServiceImpl<LmsEquipPurchaseDetailMapper, LmsEquipPurchaseDetail> implements ILmsEquipPurchaseDetailService {


    @Autowired
    private ILmsSupplierService lmsSupplierService;


    @Override
    public Page<LmsEquipPurchaseDetail> page(Page<LmsEquipPurchaseDetail> page, LmsEquipPurchaseDetail lmsEquipPurchaseDetail) {
        QueryWrapper<LmsEquipPurchaseDetail> wrapper = Wrappers.<LmsEquipPurchaseDetail>query(lmsEquipPurchaseDetail);
        return this.page(page, wrapper);
    }

    @Override
    public void  validExsitSupper(String  supperName){
        if(StringUtils.isEmpty(supperName))
            return;
        List<LmsSupplier> lstLmsSupplier =  lmsSupplierService.listByName(supperName);
        if(lstLmsSupplier == null|| lstLmsSupplier.size() == 0 ){
            LmsSupplier supplier = new LmsSupplier();
            supplier.setName(supperName);
            lmsSupplierService.save(supplier);
        }
    }


    @Override
    public List<LmsEquipPurchaseDetailVO> listVO(LmsEquipPurchaseDetailVO lmsEquipPurchaseDetailVO) {
        return baseMapper.selectPageVO(lmsEquipPurchaseDetailVO);
    }
}
