package com.patzn.lims.equip.service.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.google.common.collect.Lists;
import com.patzn.lims.common.StringHandleUtils;
import com.patzn.lims.consume.enums.PurchaseOrderEnum;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.web.Account;
import com.patzn.lims.core.web.LoginHelper;
import com.patzn.lims.equip.entity.LmsEquipInfo;
import com.patzn.lims.equip.entity.LmsEquipLocation;
import com.patzn.lims.equip.entity.LmsEquipRelDelivery;
import com.patzn.lims.equip.mapper.LmsEquipRelDeliveryMapper;
import com.patzn.lims.equip.service.ILmsEquipInfoService;
import com.patzn.lims.equip.service.ILmsEquipLocationService;
import com.patzn.lims.equip.service.ILmsEquipRelDeliveryService;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 试验耗材采购关联表 服务实现类
 * </p>
 *
 * @author wwd
 * @since 2020-03-27
 */
@Service
public class LmsEquipRelDeliveryServiceImpl extends BaseServiceImpl<LmsEquipRelDeliveryMapper, LmsEquipRelDelivery> implements ILmsEquipRelDeliveryService {

    @Autowired
    private ILmsEquipInfoService lmsEquipInfoService;
    @Autowired
    private ILmsEquipLocationService lmsEquipLocationService;

    @Override
    public Page<LmsEquipRelDelivery> page(Page<LmsEquipRelDelivery> page, LmsEquipRelDelivery lmsEquipRelDelivery) {
        QueryWrapper<LmsEquipRelDelivery> wrapper = Wrappers.<LmsEquipRelDelivery>query(lmsEquipRelDelivery);
        return this.page(page, wrapper);
    }


    @Override
    public List<String> searchLike(String item, String name) {
      List<LmsEquipRelDelivery> list= super.list(Wrappers.<LmsEquipRelDelivery>query().select(item).isNotNull(item)
                .like(StringUtils.isNotEmpty(name),item,name).groupBy(item));
      if (CollectionUtils.isEmpty(list)){
          return Lists.newArrayList();
      }
        return list.stream().map(d->{
            return StringHandleUtils.getFieldValueByFieldName(item,d);
        }).collect(Collectors.toList());
    }



    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean saveTempDeliveryByIds(Long[] equipIds, LmsEquipRelDelivery lmsEquipRelDelivery) {
        PtAssert.fail(null == equipIds || equipIds.length == 0,"请选择设备！");
        LmsEquipInfo info = new LmsEquipInfo();
        QueryWrapper wrapper = Wrappers.<LmsEquipInfo>query(info);
        if(StringUtils.isNotBlank(lmsEquipRelDelivery.getEquipNum())){
            wrapper.like("lab_num",lmsEquipRelDelivery.getEquipNum());
            lmsEquipRelDelivery.setEquipNum(null);
        }
        if(StringUtils.isNotBlank(lmsEquipRelDelivery.getEquipName())){
            wrapper.like("equip_name",lmsEquipRelDelivery.getEquipName());
            lmsEquipRelDelivery.setEquipName(null);
        }
        if(StringUtils.isNotBlank(lmsEquipRelDelivery.getSpec())){
            wrapper.like("spec",lmsEquipRelDelivery.getSpec());
            lmsEquipRelDelivery.setSpec(null);
        }
        if(StringUtils.isNotBlank(lmsEquipRelDelivery.getManufacturer())) {
            wrapper.like("manufacturer", lmsEquipRelDelivery.getManufacturer());
            lmsEquipRelDelivery.setManufacturer(null);
        }
        wrapper.in("id",equipIds);
        List<LmsEquipInfo>  lstLmsEquipInfo = lmsEquipInfoService.list(wrapper);
        Account account = LoginHelper.getAccount();
        for (LmsEquipInfo lmsEquipInfo : lstLmsEquipInfo) {
            if (null != lmsEquipInfo) {
                LmsEquipRelDelivery lcrp = baseMapper.selectChemicalRelPurchaseByAdd(lmsEquipInfo.getId(),
                        LoginHelper.getAccount().getUserId(),lmsEquipRelDelivery.getStatus()==null?-1:lmsEquipRelDelivery.getStatus());
                if (null == lcrp) {

                    // 初次新增一条记录
                    lcrp = new LmsEquipRelDelivery();
                    lcrp.setEquipId(lmsEquipInfo.getId());
                    lcrp.setEquipName(lmsEquipInfo.getName());
                    lcrp.setSpec(lmsEquipInfo.getSpec());
                    lcrp.setEquipNum(lmsEquipInfo.getLabNum());
                    lcrp.setPrice(lmsEquipInfo.getPrice());
                    lcrp.setUid(LoginHelper.getAccount().getUserId());
                    lcrp.setPerformanceStart("正常");
                    lcrp.setPerformanceEnd("正常");
                    lcrp.setManufacturer(lmsEquipInfo.getProductPlace());
                    lcrp.setApplyId(LoginHelper.getAccount().getUserId());
                    lcrp.setApplyName(LoginHelper.getAccount().getUserName());
                    if(lcrp.getUseStartTime()==null){
                        lcrp.setUseStartTime(new Date());
                    }
                    if(lcrp.getUseEndTime()==null){
                        lcrp.setUseEndTime(new Date());
                    }
                    //初始值
                    if(lmsEquipRelDelivery.getStatus() == null) {
                        lcrp.setStatus(-1);
                    }else{
                        lcrp.setStatus(lmsEquipRelDelivery.getStatus());
                    }
                    lcrp.setGrantName(account.getUserName());
                    lcrp.setCtime(new Date());
                    //获取存储位置
                    if(lmsEquipInfo.getLocationId()!=null) {
                        LmsEquipLocation location = lmsEquipLocationService.getById(lmsEquipInfo.getLocationId());
                        lcrp.setLocationName(location.getName());
                    }
                    save(lcrp);
                } else {
                    //初始值
                    if(lmsEquipRelDelivery.getStatus() == null) {
                        lcrp.setStatus(-1);
                    }else{
                        lcrp.setStatus(lmsEquipRelDelivery.getStatus());
                    }
                    lcrp.setCtime(new Date());
                    updateById(lcrp);
                }
            }
        }
        return true;
    }




    @Override
    public Page<LmsEquipRelDelivery> pageTemp(Page<LmsEquipRelDelivery> page, LmsEquipRelDelivery lmsEquipRelDelivery) {
        //设置未临时表
        if(null == lmsEquipRelDelivery.getStatus()) {
            lmsEquipRelDelivery.setStatus(-1);
        }
        QueryWrapper wrapper = Wrappers.<LmsEquipRelDelivery>query(lmsEquipRelDelivery);
        wrapper.isNull("order_id");
        lmsEquipRelDelivery.setOrderId(null);
        if(StringUtils.isNotBlank(lmsEquipRelDelivery.getEquipNum())){
            wrapper.like("equip_num",lmsEquipRelDelivery.getEquipNum());
            lmsEquipRelDelivery.setEquipNum(null);
        }
        if(StringUtils.isNotBlank(lmsEquipRelDelivery.getEquipName())){
            wrapper.like("equip_name",lmsEquipRelDelivery.getEquipName());
            lmsEquipRelDelivery.setEquipName(null);
        }
        if(StringUtils.isNotBlank(lmsEquipRelDelivery.getApplyName())){
            wrapper.like("apply_name",lmsEquipRelDelivery.getApplyName());
            lmsEquipRelDelivery.setApplyName(null);
        }
        return this.page(page, wrapper);
    }


    @Override
    public boolean updateOrderStatusFromTemp(Long orderId,  boolean approve, int status) {
        Account account = LoginHelper.getAccount();
        //获取订单
        List<LmsEquipRelDelivery> lstLmsEquipRelDelivery =
                list(Wrappers.<LmsEquipRelDelivery>query().eq("uid",account.getUserId()).eq("status",-1));
        lstLmsEquipRelDelivery.stream().forEach(c->{
            c.setOrderId(orderId);
            c.setStatus(status);
            if(approve){
                c.setState((Integer) PurchaseOrderEnum.IN_APPROVAL.getValue());
            }else{
                c.setState((int)PurchaseOrderEnum.WAIT_APPROVAL.getValue());
            }
            updateById(c);
        });
        return true;
    }


    @Override
    public boolean modifyStatusByOrderId(Long orderId, int status) {
        //獲取
        List<LmsEquipRelDelivery> lstLmsEquipRelDelivery =
                super.list(Wrappers.<LmsEquipRelDelivery>query().eq("order_id",orderId));
        List<LmsEquipRelDelivery> lstTemp = new ArrayList<>();
        if(lstLmsEquipRelDelivery!= null && lstLmsEquipRelDelivery.size() >0){
            lstLmsEquipRelDelivery.stream().forEach(c->{
                LmsEquipRelDelivery temp = new LmsEquipRelDelivery();
                temp.setId(c.getId());
                temp.setState(status);
                lstTemp.add(temp);
            });
        }
        return  super.updateBatchById(lstTemp);
    }
}
