package com.patzn.lims.equip.service.impl;

import com.baomidou.mybatisplus.core.toolkit.ArrayUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.equip.entity.LmsEquipRepairDetail;
import com.patzn.lims.equip.mapper.LmsEquipRepairDetailMapper;
import com.patzn.lims.equip.service.ILmsEquipRepairDetailService;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.equip.vo.LmsEquipRepairDetailVO;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 仪器维修详情信息表 服务实现类
 * </p>
 *
 * @author wwd
 * @since 2020-03-30
 */
@Service
public class LmsEquipRepairDetailServiceImpl extends BaseServiceImpl<LmsEquipRepairDetailMapper, LmsEquipRepairDetail> implements ILmsEquipRepairDetailService {

    @Override
    public Page<LmsEquipRepairDetail> page(Page<LmsEquipRepairDetail> page, LmsEquipRepairDetail lmsEquipRepairDetail) {
        QueryWrapper<LmsEquipRepairDetail> wrapper = Wrappers.<LmsEquipRepairDetail>query(lmsEquipRepairDetail);
        return this.page(page, wrapper);
    }


    @Override
    public List<LmsEquipRepairDetailVO> listVO(LmsEquipRepairDetailVO lmsEquipRepairDetailVO) {
        return baseMapper.selectPageVO(lmsEquipRepairDetailVO);
    }


    @Override
    public  boolean saves(Long[]ids,LmsEquipRepairDetail lmsEquipRepairDetail){
        PtAssert.fail(ArrayUtils.isEmpty(ids)||null==lmsEquipRepairDetail.getRepairId(),"请先选择记录");
        PtAssert.fail(null==lmsEquipRepairDetail.getRepairStartTimePlan()||null==lmsEquipRepairDetail.getRepairEndTimePlan()
                ||null==lmsEquipRepairDetail.getRepairerNames(),"请先输入必须填项目");
        for (int i=0;i<ids.length;i++){
            lmsEquipRepairDetail.setId(IdWorker.getId());
            lmsEquipRepairDetail.setEquipId(ids[i]);
            super.save(lmsEquipRepairDetail);
        }
        return true;
    }


    @Override
    public  List<LmsEquipRepairDetail>vagueInput(String name ,String value){
        switch (name){
            case"故障原因":
                return baseMapper.selectBreakdown(value);
            case "计划维修人":
                return    baseMapper.selectRepairerNames(value);
            case "备注":
                return baseMapper.selectRemark(value);
            default:
                return null;
        }
    }


    @Override
    public LmsEquipRepairDetailVO getVOById(Long id) {
        return baseMapper.selectVOById(id);
    }
}
