package com.patzn.lims.equip.service.impl;

import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.web.LoginHelper;
import com.patzn.lims.equip.dto.LmsEquipRepairDTO;
import com.patzn.lims.equip.entity.LmsEquipRepair;
import com.patzn.lims.equip.entity.LmsEquipRepairManage;
import com.patzn.lims.equip.entity.LmsEquipRepairManageHistory;
import com.patzn.lims.equip.mapper.LmsEquipRepairManageMapper;
import com.patzn.lims.equip.service.ILmsEquipRepairDetailService;
import com.patzn.lims.equip.service.ILmsEquipRepairManageHistoryService;
import com.patzn.lims.equip.service.ILmsEquipRepairManageService;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.equip.service.ILmsEquipRepairService;
import com.patzn.lims.equip.vo.LmsEquipRepairDetailVO;
import com.patzn.lims.equip.vo.LmsEquipRepairVO;
import com.patzn.lims.res.service.ILmsPropertyService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author wwd
 * @since 2020-03-30
 */
@Service
public class LmsEquipRepairManageServiceImpl extends BaseServiceImpl<LmsEquipRepairManageMapper, LmsEquipRepairManage> implements ILmsEquipRepairManageService {

    @Autowired
    private ILmsPropertyService lmsPropertyService;
    @Autowired
    private ILmsEquipRepairDetailService lmsEquipRepairDetailService;
    @Autowired
    private ILmsEquipRepairService lmsEquipRepairService;
    @Autowired
    private ILmsEquipRepairManageHistoryService lmsEquipRepairManageHistoryService;

    @Override
    public Page<LmsEquipRepairManage> page(Page<LmsEquipRepairManage> page, LmsEquipRepairManage lmsEquipRepairManage) {
        QueryWrapper<LmsEquipRepairManage> wrapper = Wrappers.<LmsEquipRepairManage>query(lmsEquipRepairManage);
        return this.page(page, wrapper);
    }



    @Transactional(rollbackFor = Exception.class)
    @Override
    public   boolean batchImplementation(LmsEquipRepairDTO lmsEquipRepairDTO){
        PtAssert.fail(null==lmsEquipRepairDTO, "请先选择一条记录");
        PtAssert.fail(null==lmsEquipRepairDTO.getLmsEquipRepair(),"找不到维修单");
        PtAssert.fail(lmsEquipRepairDTO.getDtoList().size()==0,"请至少选择一条实施记录");
        StringBuilder stringBuilder = new StringBuilder();
        lmsEquipRepairDTO.getDtoList().stream().forEach(dto->{
            if(null!=dto.getRepairStartTimeAct()&&null!=dto.getRepairEndTimeAct()){
                PtAssert.fail(dto.getRepairStartTimeAct().after(dto.getRepairEndTimeAct()),"开始时间不能大于结束时间");
            }
            if(null!=dto.getRepairEndTimeAct()&&null!=dto.getRepairStartTimeAct()){
                PtAssert.fail(!dto.getRepairEndTimeAct().after(dto.getRepairStartTimeAct()),"结束时间不能小于开始时间");
            }
            PtAssert.fail(null==dto.getDetailId(),"找不到维保详情单");
            LmsEquipRepairDetailVO detailVO = lmsEquipRepairDetailService.getVOById(dto.getDetailId());
            PtAssert.fail(null==detailVO,"此条详情信息不存在");
            LmsEquipRepairManage lmsOld=super.getOne(Wrappers.<LmsEquipRepairManage>query().eq("detail_id",dto.getDetailId()));
            LmsEquipRepairManage newDto =dto.convert(LmsEquipRepairManage.class);
            if(null!=lmsOld){
                stringBuilder.append(lmsPropertyService.getCompareTimeFormatDifferent(newDto, lmsOld, "仪器维修对比", ""+detailVO.getLabNum()+detailVO.getName()+":"));
                newDto.setId(lmsOld.getId());
                super.updateById(newDto);
            }else {
                stringBuilder.append(lmsPropertyService.getCompareTimeFormatDifferent(newDto, new LmsEquipRepairManage(), "仪器维修对比", ""+detailVO.getLabNum()+detailVO.getName()+":"));
                super.save(newDto);
            }
        });
        LmsEquipRepair lmsEquipRepair = lmsEquipRepairService.getById(lmsEquipRepairDTO.getLmsEquipRepair().getId());
        LmsEquipRepairManageHistory lmsEquipRepairManageHistory = new LmsEquipRepairManageHistory();
        lmsEquipRepairManageHistory.setRepairId(lmsEquipRepair.getId());
        lmsEquipRepairManageHistory.setRepairRemark(lmsEquipRepair.getApplyReason());
        lmsEquipRepairManageHistory.setNum(lmsEquipRepair.getNum());
        lmsEquipRepairManageHistory.setOperation("修改");
            lmsEquipRepairManageHistory.setDetails(stringBuilder.toString());
            lmsEquipRepairManageHistory.setUname(LoginHelper.getAccount().getUserName());
            lmsEquipRepairManageHistoryService.save(lmsEquipRepairManageHistory);

        return true;
    }


}
