package com.patzn.lims.equip.service.impl;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.equip.entity.LmsEquipScrapDetail;
import com.patzn.lims.equip.mapper.LmsEquipScrapDetailMapper;
import com.patzn.lims.equip.service.ILmsEquipScrapDetailService;
import com.patzn.lims.equip.vo.LmsEquipScrapDetailVO;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * <p>
 * 仪器报废详情信息表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2017-11-30
 */
@Service
public class LmsEquipScrapDetailServiceImpl extends BaseServiceImpl<LmsEquipScrapDetailMapper, LmsEquipScrapDetail> implements ILmsEquipScrapDetailService {

    @Override
    public Page<LmsEquipScrapDetailVO> pageVO(Page<LmsEquipScrapDetailVO> page, LmsEquipScrapDetailVO lmsEquipScrapDetailVO) {
        page.setRecords(baseMapper.selectPageVO(page, lmsEquipScrapDetailVO));
        return page;
    }

    @Override
    public List<LmsEquipScrapDetailVO> listVO(LmsEquipScrapDetailVO lmsEquipScrapDetailVO) {
        return baseMapper.selectPageVO(lmsEquipScrapDetailVO);
    }

    @Override
    public LmsEquipScrapDetailVO getVOById(Long id) {
        return baseMapper.selectVOById(id);
    }

    @Override
    public   List<LmsEquipScrapDetail>vagueInput(String name, String value){
        switch (name){
            case "报废原因":
                return  baseMapper.selectReason(value);
            case "备注":
                return  baseMapper.selectRemark(value);
                default:
                    return null;
        }

    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean bathScrapInfo(Long[] ids, LmsEquipScrapDetail lmsEquipScrapDetail) {
        PtAssert.fail(ArrayUtils.isEmpty(ids),"请选择维护内容");
        LmsEquipScrapDetail updateDetail1=new LmsEquipScrapDetail() ;
        updateDetail1.setRemark(lmsEquipScrapDetail.getRemark());
        updateDetail1.setMoney(lmsEquipScrapDetail.getMoney());
        if (StringUtils.isBlank(updateDetail1.getRemark())&&null==updateDetail1.getMoney()){
            return true;
        }
        return super.update(updateDetail1,Wrappers.<LmsEquipScrapDetail>query().in("id",ids));
    }


    @Override
    public boolean existByIds(Long[] ids) {
        return super.count(Wrappers.<LmsEquipScrapDetail>query().in("scrap_id", ids)) >= 1;
    }
    @Transactional(rollbackFor = Exception.class)
    @Override
    public  LmsEquipScrapDetail copyInput(Long id){
        LmsEquipScrapDetail detail =super.getById(id);
        PtAssert.fail(null==detail,"该条数据已经被删除,无法复制");
        detail.setId(null);
        detail.setEquipId(null);
        detail.setDeleted(0);
        return detail;
        }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean saves(Long[]ids,LmsEquipScrapDetail lmsEquipScrapDetail){
        PtAssert.fail(null==lmsEquipScrapDetail.getScrapId(),"找不到委托单");
        PtAssert.fail(ArrayUtils.isEmpty(ids),"请选择一个仪器");
        PtAssert.fail(null==lmsEquipScrapDetail.getReason(),"请输入报废原因");
        for (int i=0;i<ids.length;i++){
            lmsEquipScrapDetail.setId(IdWorker.getId());
            lmsEquipScrapDetail.setEquipId(ids[i]);
            super.save(lmsEquipScrapDetail);
        }
        return true;
    }


}
