package com.patzn.lims.equip.service.impl;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.equip.entity.LmsEquipScrapManageHistory;
import com.patzn.lims.equip.mapper.LmsEquipScrapManageHistoryMapper;
import com.patzn.lims.equip.service.ILmsEquipScrapManageHistoryService;
import com.patzn.lims.equip.vo.LmsEquipScrapManageHistoryVO;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 仪器报废历史记录表 服务实现类
 * </p>
 *
 * @author qwqwqw
 * @since 2019-01-09
 */
@Service
public class LmsEquipScrapManageHistoryServiceImpl extends BaseServiceImpl<LmsEquipScrapManageHistoryMapper, LmsEquipScrapManageHistory> implements ILmsEquipScrapManageHistoryService {


    @Override
    public Page<LmsEquipScrapManageHistoryVO> page(Page<LmsEquipScrapManageHistoryVO> page, LmsEquipScrapManageHistoryVO lmsEquipScrapManageHistory) {
        return page.setRecords(baseMapper.selectEquipScrapList(page,lmsEquipScrapManageHistory));
    }


    @Override
    public List<LmsEquipScrapManageHistory> list(LmsEquipScrapManageHistory lmsEquipScrapManageHistory) {
        return this.list(Wrappers.<LmsEquipScrapManageHistory>query(lmsEquipScrapManageHistory));
    }
}
