package com.patzn.lims.equip.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.cloud.commons.api.RestAssert;
import com.patzn.lims.core.web.LoginHelper;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.equip.dto.LmsEquipScrapDTO;
import com.patzn.lims.equip.dto.LmsEquipScrapManageDTO;
import com.patzn.lims.equip.entity.*;
import com.patzn.lims.equip.enums.EquipLogDataTypeEnum;
import com.patzn.lims.equip.enums.EquipStatusEnum;
import com.patzn.lims.equip.mapper.LmsEquipScrapManageMapper;
import com.patzn.lims.equip.service.*;
import com.patzn.lims.equip.vo.LmsEquipScrapDetailVO;
import com.patzn.lims.equip.vo.LmsEquipScrapManageVO;
import com.patzn.lims.res.service.ILmsPropertyService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * <p>
 * 仪器报废管理 服务实现类
 * </p>
 *
 * @author patzn123
 * @since 2018-01-17
 */
@Service
public class LmsEquipScrapManageServiceImpl extends BaseServiceImpl<LmsEquipScrapManageMapper, LmsEquipScrapManage> implements ILmsEquipScrapManageService {

    @Autowired
    private ILmsEquipScrapDetailService lmsEquipScrapDetailService;
    @Autowired
    private ILmsEquipInfoService lmsEquipInfoService;
    @Autowired
    private ILmsEquipLogService lmsEquipLogService;
    @Autowired
    private ILmsEquipScrapService lmsEquipScrapService;
    @Autowired
    private ILmsPropertyService lmsPropertyService;

    @Autowired
    private ILmsEquipScrapManageHistoryService lmsEquipScrapManageHistoryService;
    @Autowired
    private ILmsEquipScrapManageService lmsEquipScrapManageService;
    @Override
    public Page<LmsEquipScrapManageVO> pageVO(Page<LmsEquipScrapManageVO> page, LmsEquipScrapManageDTO lmsEquipScrapManageDTO) {
        page.setRecords(baseMapper.selectPageVO(page, lmsEquipScrapManageDTO));
        return page;
    }


    @Override
    public List<LmsEquipScrapManage> list(LmsEquipScrapManage lmsEquipScrapManage) {
        return list(Wrappers.<LmsEquipScrapManage>query(lmsEquipScrapManage));
    }


    @Override
    public LmsEquipScrapManageVO getVOById(Long id) {
        return baseMapper.selectVOById(id);
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean edit(LmsEquipScrapManage lmsEquipScrapManage) {

        RestAssert.fail(null==lmsEquipScrapManage.getDetailId(),"报废记录id不能为空");
        if (1 == lmsEquipScrapManage.getStatus()) {
            //如果是点报废操作，那么更新仪器状态为报废
            LmsEquipScrapDetail detail = lmsEquipScrapDetailService.getById(lmsEquipScrapManage.getDetailId());
            RestAssert.fail(null==detail,"报废记录不能为空");

            LmsEquipInfo info = new LmsEquipInfo();
            info.setId(detail.getEquipId());
            info.setStatus(EquipStatusEnum.SCRAP.getValue());
            lmsEquipInfoService.updateById(info);

            //保存状态日志
            List<LmsEquipLog> logs = lmsEquipLogService.list(Wrappers.<LmsEquipLog>query().eq("equip_id", detail.getEquipId()).eq("operate_date", lmsEquipScrapManage.getScrapDate()));
            if (CollectionUtils.isNotEmpty(logs)) {
                //删除当前设备报废日期后所有数据
                lmsEquipLogService.remove(Wrappers.<LmsEquipLog>query().eq("equip_id", detail.getEquipId()).ge("operate_date", lmsEquipScrapManage.getScrapDate()));
            }

            //保存仪器状态日志
            LmsEquipLog log = new LmsEquipLog();
            log.setType(EquipLogDataTypeEnum.ACT.getValue());
            log.setEquipId(detail.getEquipId());
            log.setOperateDate(lmsEquipScrapManage.getScrapDate());
            log.setStatus(EquipStatusEnum.SCRAP.getValue());
            lmsEquipLogService.save(log);
        }

        return updateById(lmsEquipScrapManage);
    }
    @Override
    @Transactional(rollbackFor = Exception.class)
    public  boolean batchImplementation(LmsEquipScrapDTO lmsEquipScrapDTO){
        RestAssert.fail(null==lmsEquipScrapDTO, "请先选择一条记录");
        RestAssert.fail(null==lmsEquipScrapDTO.getLmsEquipScrap().getId(),"找不到主核查单");
        RestAssert.fail( lmsEquipScrapDTO.getManageList().size()==0, "请至少选择一条报废数据");
        StringBuilder stringBuilder =new StringBuilder();
        lmsEquipScrapDTO.getManageList().stream().forEach(dto->{
            RestAssert.fail(null==dto.getDetailId(),"找不到报废详情单");
            LmsEquipScrapDetailVO detailVO =lmsEquipScrapDetailService.getVOById(dto.getDetailId());
            RestAssert.fail(null==detailVO,"此条详情信息不存在");
            LmsEquipScrapManage lmsOld=super.getOne(Wrappers.<LmsEquipScrapManage>query().eq("detail_id",dto.getDetailId()));
            LmsEquipScrapManage newDto =dto.convert(LmsEquipScrapManage.class);
            if(null!=lmsOld){
                newDto.setId(lmsOld.getId());
                stringBuilder.append(lmsPropertyService.getCompareTimeFormatDifferent(newDto, lmsOld, "仪器报废实施对比", ""+detailVO.getLabNum()+detailVO.getName()+":"));
                super.updateById(newDto);
            }else {
                stringBuilder.append(lmsPropertyService.getCompareTimeFormatDifferent(newDto, new LmsEquipScrapManage(), "仪器报废实施对比", ""+detailVO.getLabNum()+detailVO.getName()+":"));
                super.save(newDto);
            }
        });
        LmsEquipScrap lmsEquipRepair = lmsEquipScrapService.getById(lmsEquipScrapDTO.getLmsEquipScrap().getId());
        LmsEquipScrapManageHistory lmsEquipRepairManageHistory = new LmsEquipScrapManageHistory();
        lmsEquipRepairManageHistory.setScrapId(lmsEquipRepair.getId());
        lmsEquipRepairManageHistory.setApplyReason(lmsEquipRepair.getApplyReason());
        lmsEquipRepairManageHistory.setNum(lmsEquipRepair.getNum());
        lmsEquipRepairManageHistory.setOperation("修改");
        if(StringUtils.isNotBlank(stringBuilder)){
            lmsEquipRepairManageHistory.setDetails(stringBuilder.toString());
            lmsEquipRepairManageHistory.setUname(LoginHelper.getAccount().getUserName());
            lmsEquipScrapManageHistoryService.save(lmsEquipRepairManageHistory);
        }

        return true;
    }
}
