package com.patzn.lims.equip.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.cloud.commons.api.RestAssert;
import com.patzn.lims.common.StringStaticDataUtils;
import com.patzn.lims.core.web.Account;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.core.web.LoginHelper;
import com.patzn.lims.equip.entity.*;
import com.patzn.lims.equip.enums.EquipFileTypeEnum;
import com.patzn.lims.equip.enums.EquipScrapApplyEnum;
import com.patzn.lims.equip.mapper.LmsEquipScrapMapper;
import com.patzn.lims.equip.service.*;
import com.patzn.lims.equip.vo.LmsEquipScrapDetailVO;
import com.patzn.lims.equip.vo.LmsEquipScrapVO;
import com.patzn.lims.workflow.FlowInfo;
import com.patzn.lims.workflow.FlowType;
import com.patzn.lims.workflow.FlowVariables;
import com.patzn.lims.workflow.service.IFlowProcessService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 * 仪器报废信息表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2017-11-30
 */
@Service
public class LmsEquipScrapServiceImpl extends BaseServiceImpl<LmsEquipScrapMapper, LmsEquipScrap> implements ILmsEquipScrapService {

    @Autowired
    private IFlowProcessService flowProcessClient;
    @Autowired
    private ILmsEquipScrapDetailService lmsEquipScrapDetailService;
    @Autowired
    private ILmsEquipScrapManageService lmsEquipScrapManageService;

    @Autowired
    private ILmsEquipScrapManageHistoryService lmsEquipScrapManageHistoryService;
    @Autowired
    private ILmsEquipFileService lmsEquipFileService;

    @Autowired
    private ILmsEquipScrapService lmsEquipScrapService;
    @Override
    public Page<LmsEquipScrapVO> pageVO(Page<LmsEquipScrapVO> page, LmsEquipScrapVO lmsEquipScrap) {
        lmsEquipScrap.setCompanyId(LoginHelper.getAccount().getCompanyId());
            List<LmsEquipScrapVO> list=baseMapper.selectPageList(page,lmsEquipScrap);
        return page.setRecords(list);
    }
    @Override
    public Page<LmsEquipScrapVO> pageManage(Page<LmsEquipScrapVO> page, LmsEquipScrapVO lmsEquipScrap) {
        lmsEquipScrap.setCompanyId(LoginHelper.getAccount().getCompanyId());
        return page.setRecords(baseMapper.selectpageManage(page,lmsEquipScrap));
    }

    @Override
    public List<LmsEquipScrap> list(LmsEquipScrap lmsEquipScrap) {
        return list(Wrappers.<LmsEquipScrap>query(lmsEquipScrap));
    }


    @Override
    public LmsEquipScrapVO getTemp() {
        LmsEquipScrapVO lmsEquipScrapVO = new LmsEquipScrapVO();
        LmsEquipScrapVO ScrapVO = new LmsEquipScrapVO();
        ScrapVO.setUserId(LoginHelper.getAccount().getUserId());
        ScrapVO.setTempStatus(0);
        LmsEquipScrap lmsEquipScrap = selectOne(ScrapVO);
        if (null != lmsEquipScrap){
            BeanUtils.copyProperties(lmsEquipScrap, lmsEquipScrapVO);
            LmsEquipScrapDetailVO vo = new LmsEquipScrapDetailVO();
            vo.setScrapId(lmsEquipScrap.getId());
            List<LmsEquipScrapDetailVO> lmsEquipScrapDetailVOList = lmsEquipScrapDetailService.listVO(vo);
            lmsEquipScrapVO.setLmsEquipScrapDetailVOList(lmsEquipScrapDetailVOList);
//获取附件
            LmsEquipFile lmsEquipFile = new LmsEquipFile();
            lmsEquipFile.setRelId(lmsEquipScrap.getId());
            List<LmsEquipFile> lmsEquipFileList = lmsEquipFileService.list(lmsEquipFile);
            lmsEquipScrapVO.setLmsEquipFiles(lmsEquipFileList);
        } else {
            LmsEquipScrap scrap = new LmsEquipScrap();
            scrap.setUserId(LoginHelper.getAccount().getUserId());
            scrap.setTempStatus(0);
            super.save(scrap);
            BeanUtils.copyProperties(scrap, lmsEquipScrapVO);
            LmsEquipFile lmsEquipFile = new LmsEquipFile();
            lmsEquipFile.setRelId(scrap.getId());
            List<LmsEquipFile> lmsEquipFileList = lmsEquipFileService.list(lmsEquipFile);
            lmsEquipScrapVO.setLmsEquipFiles(lmsEquipFileList);
        }
        return lmsEquipScrapVO;
    }


    @Override
    public LmsEquipScrapVO getTemp(Long[] ids) {
        LmsEquipScrapVO lmsEquipScrapVO = new LmsEquipScrapVO();
        LmsEquipScrapVO ScrapVO = new LmsEquipScrapVO();
        ScrapVO.setUserId(LoginHelper.getAccount().getUserId());
        ScrapVO.setTempStatus(0);
        LmsEquipScrap lmsEquipScrap = selectOne(ScrapVO);
        if (null == lmsEquipScrap){
            LmsEquipScrap scrap = new LmsEquipScrap();
            scrap.setUserId(LoginHelper.getAccount().getUserId());
            scrap.setTempStatus(0);
            super.save(scrap);
            lmsEquipScrap=scrap;
        }
        for (Long id:ids) {
            LmsEquipScrapDetail detailVO=new LmsEquipScrapDetail();
            detailVO.setEquipId(id);
            detailVO.setScrapId(lmsEquipScrap.getId());
            lmsEquipScrapDetailService.save(detailVO);

        }
        BeanUtils.copyProperties(lmsEquipScrap, lmsEquipScrapVO);
        LmsEquipScrapDetailVO vo = new LmsEquipScrapDetailVO();
        vo.setScrapId(lmsEquipScrap.getId());
        List<LmsEquipScrapDetailVO> lmsEquipScrapDetailVOList = lmsEquipScrapDetailService.listVO(vo);
        lmsEquipScrapVO.setLmsEquipScrapDetailVOList(lmsEquipScrapDetailVOList);
        return lmsEquipScrapVO;
    }

    @Override
    public boolean submit(Long id) {
        try {
            LmsEquipScrap lmsEquipScrap = baseMapper.selectById(id);
            ArrayList<FlowInfo> flowInfoList = new ArrayList<>();
            Account account = com.patzn.lims.core.web.LoginHelper.getAccount();
            //发起流程
            flowInfoList.add(FlowInfo.convertFlowInfo(FlowType.EQUIP_SCRAP,
                    account, lmsEquipScrap.getId(), lmsEquipScrap.getApplyReason()));
            flowProcessClient.saveTask(flowInfoList,account);
            //更新报废申请状态
            lmsEquipScrap.setStatus((Integer) EquipScrapApplyEnum.TECHNOLOGY_CHECK.getValue());
            lmsEquipScrap.setApplyId(LoginHelper.getAccount().getUserId());
            lmsEquipScrap.setApplyName(LoginHelper.getAccount().getUserName());
            lmsEquipScrap.setApplyTime(new Date());
            baseMapper.updateById(lmsEquipScrap);
        } catch (Exception ex) {
            RestAssert.fail("流程提交失败，原因：" + ex.getMessage());
        }

        return true;
    }
    @Override
    public boolean edit(LmsEquipScrap lmsEquipScrap){
        RestAssert.fail(StringUtils.isBlank(lmsEquipScrap.getNum()),"找不到该编号");

          super.updateById(lmsEquipScrap);
    //提交

        if (EquipScrapApplyEnum.TECHNOLOGY_CHECK.getValue().equals(lmsEquipScrap.getStatus())){
  submit(lmsEquipScrap.getId());
    }
    return  true;
    }

    @Override
    public boolean approve(String taskId, String status, String reason) {
        FlowVariables flowVariables = new FlowVariables(taskId);
        FlowInfo flowInfo = null;
        Map<String, Object> map = new HashMap<>(2);

        if ("success".equals(status)) {
            // 确认审批完成
             flowInfo = flowProcessClient.complete(taskId);
             RestAssert.fail(null == flowInfo,"确认审批失败！");
              //保存报废管理
                List<LmsEquipScrapDetail> detailList = lmsEquipScrapDetailService.list(Wrappers.<LmsEquipScrapDetail>query().eq("scrap_id", flowInfo.getId()));
                if (null != detailList && detailList.size() > 0) {
                    List<LmsEquipScrapManage> manageList = detailList.stream().map(e -> {
                        LmsEquipScrapManage manage = new LmsEquipScrapManage();
                        manage.setDetailId(e.getId());
                        manage.setStatus(0);
                        return manage;
                    }).collect(Collectors.toList());
                    lmsEquipScrapManageService.saveBatch(manageList);
                }

        } else if ("false".equals(status)) {
            flowInfo = flowProcessClient.complete(taskId);
        } else if ("2".equals(status)) {
            //技术主管审批通过
            map.put("technicalDirectorAduitPass", true);
            flowVariables.setVariables(map);
            flowInfo = flowProcessClient.complete(flowVariables);
        } else if ("3".equals(status)) {
            //技术主管审批驳回
            map.put(FlowInfo.APPLY_ID, LoginHelper.getAccount().getUserId());
            map.put("technicalDirectorAduitPass", false);
            flowVariables.setVariables(map);
            flowInfo = flowProcessClient.complete(flowVariables);
        } else if ("7".equals(status)) {
            //终止
            map.put(FlowInfo.APPLY_ID, LoginHelper.getAccount().getUserId());
            map.put("technicalDirectorAduitPass", false);
            flowVariables.setVariables(map);
            flowInfo = flowProcessClient.complete(flowVariables);
        } else if ("4".equals(status)) {
            //中心主任审批通过
            map.put(FlowInfo.APPLY_ID, LoginHelper.getAccount().getUserId());
            map.put("centerDirectorAduitPass", true);
            flowVariables.setVariables(map);
            flowInfo = flowProcessClient.complete(flowVariables);
        } else if ("5".equals(status)) {
            //中心主任审批驳回
            map.put(FlowInfo.APPLY_ID, LoginHelper.getAccount().getUserId());
            map.put("centerDirectorAduitPass", false);
            flowVariables.setVariables(map);
            flowInfo = flowProcessClient.complete(flowVariables);
        } else {
            return false;
        }

        if (null != flowInfo && null != updateScrap(flowInfo, status, reason)) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public LmsEquipScrap selectOne(LmsEquipScrap queryBean) {
        QueryWrapper wrapper = Wrappers.query(queryBean);
        return baseMapper.selectOne(wrapper);
    }

    public boolean statusCount(Long []ids){
        return ids.length==super.count(Wrappers.<LmsEquipScrap>query().in("id",ids).eq("status",0));
    }
    @Override
    public boolean removeIds(Long[] ids) {
   RestAssert.fail(!statusCount(ids),"存在已被提交的，无法删除");
        return super.remove(Wrappers.<LmsEquipScrap>query().in("id", ids));
    }
    @Override
    public LmsEquipFile uploadFile(MultipartFile file, LmsEquipScrap lmsEquipScrap){
        RestAssert.fail(null==lmsEquipScrap.getId(),"请选择一条记录");
        Long companyId = LoginHelper.getAccount().getCompanyId();
        LmsEquipScrap lmsEquipRep = super.getById(lmsEquipScrap.getId());
        LmsEquipScrapManageHistory lmsEquipScrapManageHistory =new LmsEquipScrapManageHistory();
        lmsEquipScrapManageHistory.setScrapId(lmsEquipScrap.getId());
        lmsEquipScrapManageHistory.setDetails("文件名:"+file.getOriginalFilename());
        lmsEquipScrapManageHistory.setUname(LoginHelper.getAccount().getUserName());
        lmsEquipScrapManageHistory.setApplyReason(lmsEquipRep.getApplyReason());
        lmsEquipScrapManageHistory.setNum(null==lmsEquipRep.getNum()?"创建前上传":lmsEquipRep.getNum());
        lmsEquipScrapManageHistory.setOperation("上传");
        lmsEquipScrapManageHistoryService.save(lmsEquipScrapManageHistory);
        //区分公司
        return lmsEquipFileService.saveAndUpload(file, "lims", "equip/flow/check/" + companyId + "/", lmsEquipScrap.getId(), EquipFileTypeEnum.CHECK.getValue());
    }
    @Override
    public   boolean deleteFiles(Long id,Long scrapId){
        Long[] ids = new Long[]{id};
        List<LmsEquipFile> equipFileList = lmsEquipFileService.list(Wrappers.<LmsEquipFile>query().in("id", ids));
        String nameFile =equipFileList.stream().map(e->e.getOrginName()).collect(Collectors.joining(","));
        LmsEquipScrapManageHistory lmsEquipRepairManageHistory =new LmsEquipScrapManageHistory();
        LmsEquipScrap msEquipRepair = super.getById(scrapId);
        RestAssert.fail(null==msEquipRepair,"该报废单已被删除,不可删除附件");
        lmsEquipRepairManageHistory.setScrapId(scrapId);
        lmsEquipRepairManageHistory.setApplyReason(msEquipRepair.getApplyReason());
        lmsEquipRepairManageHistory.setNum(msEquipRepair.getNum());
        lmsEquipRepairManageHistory.setOperation("删除");
        lmsEquipRepairManageHistory.setDetails("删除附件名称:"+nameFile);
        lmsEquipRepairManageHistory.setUname(LoginHelper.getAccount().getUserName());
        lmsEquipScrapManageHistoryService.save(lmsEquipRepairManageHistory);
        return lmsEquipFileService.deleteBatch(ids);

    }

    @Override
    public void downloadFile(Long id, HttpServletResponse response) {
        LmsEquipFile lmsEquipFile = lmsEquipFileService.getById(id);
        String fileUrl = lmsEquipFile.getFilePath();
        String orgFileName = lmsEquipFile.getOrginName().replaceAll("\\s*", "");
        lmsEquipFileService.downloadFile(response, "lims", fileUrl, orgFileName);
    }

    private Integer updateScrap(FlowInfo flowInfo, String status, String reason) {
        LmsEquipScrap lmsEquipScrap = new LmsEquipScrap();
        lmsEquipScrap.setId(flowInfo.getId());
        if (StringStaticDataUtils.SUCCESS.equals(status) || StringStaticDataUtils.FALSE.equals(status)) {
            lmsEquipScrap.setStatus((Integer) EquipScrapApplyEnum.END.getValue());
        } else if (EquipScrapApplyEnum.DIRECTOR_CENTER_CHECK.getValue().toString().equals(status)) {
            //技术主管审批通过
            lmsEquipScrap.setStatus((Integer)EquipScrapApplyEnum.DIRECTOR_CENTER_CHECK.getValue());
            lmsEquipScrap.setFirstStepId(LoginHelper.getAccount().getUserId());
            lmsEquipScrap.setFirstStepTime(new Date());
            lmsEquipScrap.setFirstStepAdvice(reason);
            lmsEquipScrap.setFirstStepName(LoginHelper.getAccount().getUserName());
        } else if (EquipScrapApplyEnum.TECHNOLOGY_CHECK_BACK.getValue().toString().equals(status)) {
            //技术主管审批驳回
            lmsEquipScrap.setStatus((Integer) EquipScrapApplyEnum.TECHNOLOGY_CHECK_BACK.getValue());
            lmsEquipScrap.setFirstStepId(LoginHelper.getAccount().getUserId());
            lmsEquipScrap.setFirstStepTime(new Date());
            lmsEquipScrap.setFirstStepAdvice(reason);
            lmsEquipScrap.setFirstStepName(LoginHelper.getAccount().getUserName());
        } else if (EquipScrapApplyEnum.STOP.getValue().toString().equals(status)) {
            //技术主管审批终止
            lmsEquipScrap.setStatus((Integer)EquipScrapApplyEnum.STOP.getValue());
            lmsEquipScrap.setFirstStepId(LoginHelper.getAccount().getUserId());
            lmsEquipScrap.setFirstStepTime(new Date());
            lmsEquipScrap.setFirstStepAdvice(reason);
            lmsEquipScrap.setFirstStepName(LoginHelper.getAccount().getUserName());
        } else if (EquipScrapApplyEnum.DIRECTOR_CENTER_PASS.getValue().toString().equals(status)) {
            lmsEquipScrap.setStatus((Integer)EquipScrapApplyEnum.DIRECTOR_CENTER_PASS.getValue());
            lmsEquipScrap.setSecondStepId(LoginHelper.getAccount().getUserId());
            lmsEquipScrap.setSecondStepTime(new Date());
            lmsEquipScrap.setSecondStepAdvice(reason);
            lmsEquipScrap.setSecondStepName(LoginHelper.getAccount().getUserName());
        } else if (EquipScrapApplyEnum.DIRECTOR_CENTER_BACK.getValue().toString().equals(status)) {
            lmsEquipScrap.setStatus((Integer)EquipScrapApplyEnum.DIRECTOR_CENTER_BACK.getValue());
            lmsEquipScrap.setSecondStepId(LoginHelper.getAccount().getUserId());
            lmsEquipScrap.setSecondStepTime(new Date());
            lmsEquipScrap.setSecondStepAdvice(reason);
            lmsEquipScrap.setSecondStepName(LoginHelper.getAccount().getUserName());
        } else {
            return null;
        }

        return baseMapper.updateById(lmsEquipScrap);
    }
    @Override
    public boolean inputNum(Long id,String num) {
        LmsEquipScrap lmsEquipRepair = super.getById(id);
        if (null != lmsEquipRepair.getNum() && lmsEquipRepair.getNum().equals(num)) {
            return 1 == super.count(Wrappers.<LmsEquipScrap>query().eq("num", num));
        } else if (null != lmsEquipRepair.getNum() && !lmsEquipRepair.getNum().equals(num)) {
            return 0 == super.count(Wrappers.<LmsEquipScrap>query().eq("num", num));
        } else {
            return 0 == super.count(Wrappers.<LmsEquipScrap>query().eq("num", num));
        }
    }
        @Override
    public   boolean addOne(LmsEquipScrap lmsEquipScrap){
        RestAssert.fail(!inputNum(lmsEquipScrap.getId(),lmsEquipScrap.getNum()),"编号重复重新填写");
      lmsEquipScrap.setRegisterId(LoginHelper.getAccount().getUserId());
        lmsEquipScrap.setRegisterName(LoginHelper.getAccount().getUserName());
        lmsEquipScrap.setRegisterTime(new Date());
    LmsEquipScrap Scrap = new LmsEquipScrap();
        Scrap.setUserId(LoginHelper.getAccount().getUserId());
        Scrap.setTempStatus(0);
    LmsEquipScrap temp = lmsEquipScrapService.selectOne(Scrap);
        if (null != temp){
        lmsEquipScrap.setId(temp.getId());
        lmsEquipScrap.setTempStatus(1);
        lmsEquipScrapService.updateById(lmsEquipScrap);
    } else {
        lmsEquipScrap.setUserId(LoginHelper.getAccount().getUserId());
        lmsEquipScrap.setTempStatus(1);
        lmsEquipScrapService.save(lmsEquipScrap);
    }

    //提交
        if (EquipScrapApplyEnum.TECHNOLOGY_CHECK.getValue().equals(lmsEquipScrap.getStatus())){
        lmsEquipScrapService.submit(lmsEquipScrap.getId());
    }
    return true;
    }
}
