package com.patzn.lims.equip.service.impl;

import com.patzn.lims.core.web.LoginHelper;
import com.patzn.lims.equip.dto.LmsEquipUseRecordDTO;
import com.patzn.lims.equip.entity.LmsEquipLog;
import com.patzn.lims.equip.entity.LmsEquipUseRecord;
import com.patzn.lims.equip.enums.EquipLogDataTypeEnum;
import com.patzn.lims.equip.enums.EquipLogStatusEnum;
import com.patzn.lims.equip.mapper.LmsEquipUseRecordMapper;
import com.patzn.lims.equip.service.ILmsEquipLogService;
import com.patzn.lims.equip.service.ILmsEquipUseRecordService;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.equip.vo.LmsEquipUseRecordVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

/**
 * <p>
 * 仪器使用记录信息表 服务实现类
 * </p>
 *
 * @author wwd
 * @since 2020-03-28
 */
@Service
public class LmsEquipUseRecordServiceImpl extends BaseServiceImpl<LmsEquipUseRecordMapper, LmsEquipUseRecord> implements ILmsEquipUseRecordService {

    @Autowired
    private ILmsEquipLogService lmsEquipLogService;


    @Override
    public Page<LmsEquipUseRecord> page(Page<LmsEquipUseRecord> page, LmsEquipUseRecord lmsEquipUseRecord) {
        QueryWrapper<LmsEquipUseRecord> wrapper = Wrappers.<LmsEquipUseRecord>query(lmsEquipUseRecord);
        return this.page(page, wrapper);
    }

    @Override
    public Page<LmsEquipUseRecordVO> pageVO(Page<LmsEquipUseRecordVO> page, LmsEquipUseRecordDTO lmsEquipUseRecordDTO) {
        page.setRecords(baseMapper.selectPageVO(page, lmsEquipUseRecordDTO));
        return page;
    }


    @Override
    public LmsEquipUseRecordVO getVOById(Long id) {
        return baseMapper.selectVOById(id);
    }

    @Override
    public LmsEquipUseRecordVO getCopyVOById(Long id) {
        LmsEquipUseRecordVO vo = baseMapper.selectVOById(id);
        vo.setId(null);
        return vo;
    }



    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean add(LmsEquipUseRecord lmsEquipUseRecord) {
        lmsEquipUseRecord.setRegisterId(LoginHelper.getAccount().getUserId());
        lmsEquipUseRecord.setRegisterName(LoginHelper.getAccount().getUserName());
        lmsEquipUseRecord.setRegisterTime(new Date());
        lmsEquipUseRecord.setType(0);
        lmsEquipUseRecord.setIsReturn(lmsEquipUseRecord.getStatus() == 0 ? 0 : 1);
        return save(lmsEquipUseRecord);
    }




    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean edit(LmsEquipUseRecord lmsEquipUseRecord) {
        LmsEquipLog log = new LmsEquipLog();
        log.setRelId(lmsEquipUseRecord.getId());
        log.setEquipId(lmsEquipUseRecord.getEquipId());
        log.setStartTime(lmsEquipUseRecord.getUseStartTime());
        log.setEndTime(lmsEquipUseRecord.getUseEndTime());
        //数据提交保存日志信息
        if (1 == lmsEquipUseRecord.getStatus()) {
            lmsEquipLogService.remove(Wrappers.<LmsEquipLog>query().eq("rel_id", lmsEquipUseRecord.getId()));
            lmsEquipLogService.saveLogs(lmsEquipUseRecord.getUseStartTime(), lmsEquipUseRecord.getUseEndTime(), lmsEquipUseRecord.getEquipId(), lmsEquipUseRecord.getId(), EquipLogStatusEnum.USE.getValue(), EquipLogDataTypeEnum.ACT.getValue());
        }
        LmsEquipUseRecord record = getById(lmsEquipUseRecord.getId());
        if (record.getType() == 0) {
            lmsEquipUseRecord.setIsReturn(lmsEquipUseRecord.getStatus() == 0 ? 0 : 1);
        }
        return updateById(lmsEquipUseRecord);
    }
}
