package com.patzn.lims.equip.vo;
import com.patzn.lims.equip.entity.LmsEquipRepairDetail;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 仪器维修详情信息表
 * </p>
 *
 * @author patzn
 * @since 2017-11-30
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsEquipRepairDetailVO extends LmsEquipRepairDetail {

	private String supplierName;

	private String className;

	private String name;

	private String spec;

	private String brand;

	private BigDecimal price;

	private String productPlace;

	private String meterType;

	private String uncertainty;

	private String accuracy;

	private String range;

	private String equipNum;

	private String ceNum;

	private String labNum;

	private String departmentName;

	private String locationName;

	private String period;

	private Date buyDate;

	private Date effectDate;
	@ApiModelProperty(value = "维修方法与内容")
	private String repairMethod;
	@ApiModelProperty(value = "维修费用")
	private BigDecimal repairFee;
	@ApiModelProperty(value = "实际维修开始时间")
	private Date repairStartTimeAct;
	@ApiModelProperty(value = "实际维修结束时间")
	private Date repairEndTimeAct;
	@ApiModelProperty(value = "实际维修人")
	private String repairerNamesAct;
}
