package com.patzn.lims.equip.vo;

import com.patzn.lims.equip.entity.LmsEquipFile;
import com.patzn.lims.equip.entity.LmsEquipRepair;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 仪器维修信息表
 * </p>
 *
 * @author patzn
 * @since 2017-11-30
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsEquipRepairVO extends LmsEquipRepair {
	private String keyword;

	@ApiModelProperty(value = "申请时间左边")
	private Date applyBeginTime;

	@ApiModelProperty(value = "申请时间右边")
	private Date applyEndTime;
	private List<LmsEquipRepairDetailVO> lmsEquipRepairDetailVOList;

	@ApiModelProperty(value = "涉及仪器")
	private String equipNames;

	@ApiModelProperty(value = "涉及仪器详情")
	private String equipNameNums;

	@ApiModelProperty(value = "涉及仪器附件")
	private List<LmsEquipFile> lmsEquipFiles;
}
