package com.patzn.lims.equip.vo;
import com.patzn.lims.equip.entity.LmsEquipScrapDetail;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 仪器报废详情信息表
 * </p>
 *
 * @author patzn
 * @since 2017-11-30
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsEquipScrapDetailVO extends LmsEquipScrapDetail {


	private String keyword;

	private String supplierName;

	private String className;

	private String name;

	private String spec;

	private String brand;

	private BigDecimal price;

	private String productPlace;

	private String meterType;

	private String uncertainty;

	private String accuracy;

	private String range;

	private String equipNum;

	private String ceNum;

	private String labNum;

	private String departmentName;

	private String locationName;

	private String period;

	private Date buyDate;

	private Date effectDate;
@ApiModelProperty(value = "报废时间")
	private Date scrapDate;
@ApiModelProperty(value = "实际报废费用")
	private BigDecimal scrapFee;
@ApiModelProperty(value ="实际报废负责人" )
	private String scrapNameAct;
@ApiModelProperty(value = "报废处理方式")
	private String scrapMode;

@ApiModelProperty(value = "申请人")
	private String applyName;

}
