package com.patzn.lims.equip.vo;

import com.patzn.lims.equip.entity.LmsEquipFile;
import com.patzn.lims.equip.entity.LmsEquipScrap;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 仪器报废信息表
 * </p>
 *
 * @author patzn
 * @since 2017-11-30
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsEquipScrapVO extends LmsEquipScrap {

    private String keyword;

    private List<LmsEquipScrapDetailVO> lmsEquipScrapDetailVOList;

    @ApiModelProperty(value = "申请时间左边")
    private Date applyLeftTime;

    @ApiModelProperty(value = "申请时间右边")
    private Date applyRightTime;

    @ApiModelProperty("涉及仪器")
    private String equipNames;
    @ApiModelProperty("涉及仪器详情")
    private String equipNameNums;

    private List<LmsEquipFile> lmsEquipFiles;

    @ApiModelProperty("状态数字")
    private Integer state;


}
