package com.patzn.lims.excel.handler;


import com.patzn.lims.excel.eto.EnvMicrobeMonitorETO;
import com.patzn.poibox.excel.AbstractExeclExportHandler;
import com.patzn.poibox.excel.IExcelTemplate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EnvMicrobeMonitorExportHandler extends AbstractExeclExportHandler {

    private List<EnvMicrobeMonitorETO> monitorList = null;

    public EnvMicrobeMonitorExportHandler(List<EnvMicrobeMonitorETO> monitorList) {
        this.monitorList = monitorList;
    }

    @Override
    public IExcelTemplate exportTemplate() {
        return new IExcelTemplate() {
            @Override
            public String tplname() {
                return "MicrobeMonitorTpl";
            }

            @Override
            public String outname() {
                return "微生物检测环境检测";
            }
        };
    }

    @Override
    protected Map<String, Object> renderData() {
        Map<String, Object> objMap = new HashMap<>(1);
        objMap.put("monitorList", monitorList);
        return objMap;
    }
}
