package com.patzn.lims.excel.handler;

import com.patzn.lims.excel.eto.EnvNormalMonitorETO;
import com.patzn.poibox.excel.AbstractExeclExportHandler;
import com.patzn.poibox.excel.IExcelTemplate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class EnvNormalMonitorExportHandler extends AbstractExeclExportHandler {

    private List<EnvNormalMonitorETO> monitorList = null;

    public EnvNormalMonitorExportHandler(List<EnvNormalMonitorETO> monitorList) {
        this.monitorList = monitorList;
    }

    @Override
    public IExcelTemplate exportTemplate() {
        return new IExcelTemplate() {
            @Override
            public String tplname() {
                return "NormalMonitorTpl";
            }

            @Override
            public String outname() {
                return "常规检测环境检测";
            }
        };
    }

    @Override
    protected Map<String, Object> renderData() {
        Map<String, Object> objMap = new HashMap<>(1);
        objMap.put("monitorList", monitorList);
        return objMap;
    }
}
