package com.patzn.lims.excel.handler;

import com.patzn.lims.excel.eto.LmsMonthPlanETO;
import com.patzn.poibox.excel.AbstractExeclExportHandler;
import com.patzn.poibox.excel.IExcelTemplate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 不确定度评定计划导出
 */
public class LmsMonthPlanExportHandler extends AbstractExeclExportHandler {

    private List<LmsMonthPlanETO> itemList = null;

    public LmsMonthPlanExportHandler(List<LmsMonthPlanETO> itemList) {
        this.itemList = itemList;
    }

    @Override
    public IExcelTemplate exportTemplate() {
        return new IExcelTemplate() {
            @Override
            public String tplname() {
                return "LmsMonthPlanTpl";
            }

            @Override
            public String outname() {
                return "计划导出";
            }
        };
    }

    @Override
    protected Map<String, Object> renderData() {
        Map<String, Object> objMap = new HashMap<>(1);
        objMap.put("itemList", itemList);
        return objMap;
    }
}
